/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.store;

import com.icegreen.greenmail.foedus.util.MsgRangeFilter;
import com.icegreen.greenmail.imap.ImapConstants;
import com.icegreen.greenmail.mail.MovingMessage;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.FolderListener;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.MessageFlags;
import com.icegreen.greenmail.store.SimpleStoredMessage;
import com.icegreen.greenmail.store.Store;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.search.SearchTerm;

public class InMemoryStore
implements Store,
ImapConstants {
    private RootFolder rootMailbox = new RootFolder();
    private static final Flags PERMANENT_FLAGS = new Flags();

    public MailFolder getMailbox(String string) {
        String string2;
        HierarchicalFolder hierarchicalFolder;
        StringTokenizer stringTokenizer = new StringTokenizer(string, HIERARCHY_DELIMITER);
        if (!stringTokenizer.hasMoreTokens() || !stringTokenizer.nextToken().equalsIgnoreCase("#mail")) {
            return null;
        }
        for (hierarchicalFolder = this.rootMailbox; hierarchicalFolder != null && stringTokenizer.hasMoreTokens(); hierarchicalFolder = hierarchicalFolder.getChild(string2)) {
            string2 = stringTokenizer.nextToken();
        }
        return hierarchicalFolder;
    }

    public MailFolder getMailbox(MailFolder mailFolder, String string) {
        return ((HierarchicalFolder)mailFolder).getChild(string);
    }

    public MailFolder createMailbox(MailFolder mailFolder, String string, boolean bl) throws FolderException {
        if (string.indexOf(46) != -1) {
            throw new FolderException("Invalid mailbox name.");
        }
        HierarchicalFolder hierarchicalFolder = (HierarchicalFolder)mailFolder;
        HierarchicalFolder hierarchicalFolder2 = new HierarchicalFolder(hierarchicalFolder, string);
        hierarchicalFolder.getChildren().add(hierarchicalFolder2);
        hierarchicalFolder2.setSelectable(bl);
        return hierarchicalFolder2;
    }

    public void deleteMailbox(MailFolder mailFolder) throws FolderException {
        HierarchicalFolder hierarchicalFolder = (HierarchicalFolder)mailFolder;
        if (!hierarchicalFolder.getChildren().isEmpty()) {
            throw new FolderException("Cannot delete mailbox with children.");
        }
        if (hierarchicalFolder.getMessageCount() != 0) {
            throw new FolderException("Cannot delete non-empty mailbox");
        }
        HierarchicalFolder hierarchicalFolder2 = hierarchicalFolder.getParent();
        hierarchicalFolder2.getChildren().remove(hierarchicalFolder);
    }

    public void renameMailbox(MailFolder mailFolder, String string) throws FolderException {
        HierarchicalFolder hierarchicalFolder = (HierarchicalFolder)mailFolder;
        hierarchicalFolder.setName(string);
    }

    public Collection getChildren(MailFolder mailFolder) {
        Collection collection = ((HierarchicalFolder)mailFolder).getChildren();
        return Collections.unmodifiableCollection(collection);
    }

    public MailFolder setSelectable(MailFolder mailFolder, boolean bl) {
        ((HierarchicalFolder)mailFolder).setSelectable(bl);
        return mailFolder;
    }

    public Collection listMailboxes(String string) throws FolderException {
        int n = string.indexOf(42);
        int n2 = string.indexOf(37);
        if (n > -1 && n < string.length() - 1 || n2 > -1 && n2 < string.length() - 1) {
            throw new FolderException("WIldcard characters are only handled as the last character of a list argument.");
        }
        ArrayList<MailFolder> arrayList = new ArrayList<MailFolder>();
        if (n != -1 || n2 != -1) {
            int n3 = string.lastIndexOf(HIERARCHY_DELIMITER);
            String string2 = n3 < 0 ? "#mail" : string.substring(0, n3);
            String string3 = string.substring(n3 + 1, string.length() - 1);
            HierarchicalFolder hierarchicalFolder = (HierarchicalFolder)this.getMailbox(string2);
            if (hierarchicalFolder != null) {
                Iterator iterator = hierarchicalFolder.getChildren().iterator();
                while (iterator.hasNext()) {
                    HierarchicalFolder hierarchicalFolder2 = (HierarchicalFolder)iterator.next();
                    if (!hierarchicalFolder2.getName().startsWith(string3)) continue;
                    arrayList.add(hierarchicalFolder2);
                    if (n == -1) continue;
                    this.addAllChildren(hierarchicalFolder2, arrayList);
                }
            }
        } else {
            MailFolder mailFolder = this.getMailbox(string);
            if (mailFolder != null) {
                arrayList.add(mailFolder);
            }
        }
        return arrayList;
    }

    private void addAllChildren(HierarchicalFolder hierarchicalFolder, Collection collection) {
        Collection collection2 = hierarchicalFolder.getChildren();
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            HierarchicalFolder hierarchicalFolder2 = (HierarchicalFolder)iterator.next();
            collection.add(hierarchicalFolder2);
            this.addAllChildren(hierarchicalFolder2, collection);
        }
    }

    static {
        PERMANENT_FLAGS.add(Flags.Flag.ANSWERED);
        PERMANENT_FLAGS.add(Flags.Flag.DELETED);
        PERMANENT_FLAGS.add(Flags.Flag.DRAFT);
        PERMANENT_FLAGS.add(Flags.Flag.FLAGGED);
        PERMANENT_FLAGS.add(Flags.Flag.SEEN);
    }

    private class HierarchicalFolder
    implements MailFolder {
        private Collection children;
        private HierarchicalFolder parent;
        protected String name;
        private boolean isSelectable = false;
        private List mailMessages = Collections.synchronizedList(new LinkedList());
        private long nextUid = 1L;
        private long uidValidity;
        private List _mailboxListeners = Collections.synchronizedList(new LinkedList());

        public HierarchicalFolder(HierarchicalFolder hierarchicalFolder, String string) {
            this.name = string;
            this.children = new ArrayList();
            this.parent = hierarchicalFolder;
            this.uidValidity = System.currentTimeMillis();
        }

        public Collection getChildren() {
            return this.children;
        }

        public HierarchicalFolder getParent() {
            return this.parent;
        }

        public HierarchicalFolder getChild(String string) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                HierarchicalFolder hierarchicalFolder = (HierarchicalFolder)iterator.next();
                if (!hierarchicalFolder.getName().equalsIgnoreCase(string)) continue;
                return hierarchicalFolder;
            }
            return null;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String getFullName() {
            return this.parent.getFullName() + '.' + this.name;
        }

        public Flags getPermanentFlags() {
            return PERMANENT_FLAGS;
        }

        public int getMessageCount() {
            return this.mailMessages.size();
        }

        public long getUidValidity() {
            return this.uidValidity;
        }

        public long getUidNext() {
            return this.nextUid;
        }

        public int getUnseenCount() {
            int n = 0;
            for (int i = 0; i < this.mailMessages.size(); ++i) {
                SimpleStoredMessage simpleStoredMessage = (SimpleStoredMessage)this.mailMessages.get(i);
                if (simpleStoredMessage.getFlags().contains(Flags.Flag.SEEN)) continue;
                ++n;
            }
            return n;
        }

        public int getFirstUnseen() {
            for (int i = 0; i < this.mailMessages.size(); ++i) {
                SimpleStoredMessage simpleStoredMessage = (SimpleStoredMessage)this.mailMessages.get(i);
                if (simpleStoredMessage.getFlags().contains(Flags.Flag.SEEN)) continue;
                return i + 1;
            }
            return -1;
        }

        public int getRecentCount(boolean bl) {
            int n = 0;
            for (int i = 0; i < this.mailMessages.size(); ++i) {
                SimpleStoredMessage simpleStoredMessage = (SimpleStoredMessage)this.mailMessages.get(i);
                if (!simpleStoredMessage.getFlags().contains(Flags.Flag.RECENT)) continue;
                ++n;
                if (!bl) continue;
                simpleStoredMessage.getFlags().remove(Flags.Flag.RECENT);
            }
            return n;
        }

        public int getMsn(long l) throws FolderException {
            for (int i = 0; i < this.mailMessages.size(); ++i) {
                SimpleStoredMessage simpleStoredMessage = (SimpleStoredMessage)this.mailMessages.get(i);
                if (simpleStoredMessage.getUid() != l) continue;
                return i + 1;
            }
            throw new FolderException("No such message.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void signalDeletion() {
            List list = this._mailboxListeners;
            synchronized (list) {
                for (int i = 0; i < this._mailboxListeners.size(); ++i) {
                    FolderListener folderListener = (FolderListener)this._mailboxListeners.get(i);
                    folderListener.mailboxDeleted();
                }
            }
        }

        public List getMessages(MsgRangeFilter msgRangeFilter) {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mailMessages.size(); ++i) {
                if (!msgRangeFilter.includes(i + 1)) continue;
                arrayList.add(this.mailMessages.get(i));
            }
            return arrayList;
        }

        public List getMessages() {
            return this.mailMessages;
        }

        public List getNonDeletedMessages() {
            ArrayList<SimpleStoredMessage> arrayList = new ArrayList<SimpleStoredMessage>();
            for (int i = 0; i < this.mailMessages.size(); ++i) {
                SimpleStoredMessage simpleStoredMessage = (SimpleStoredMessage)this.mailMessages.get(i);
                if (simpleStoredMessage.getFlags().contains(Flags.Flag.DELETED)) continue;
                arrayList.add(simpleStoredMessage);
            }
            return arrayList;
        }

        public boolean isSelectable() {
            return this.isSelectable;
        }

        public void setSelectable(boolean bl) {
            this.isSelectable = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long appendMessage(MimeMessage mimeMessage, Flags flags, Date date) {
            long l = this.nextUid++;
            SimpleStoredMessage simpleStoredMessage = new SimpleStoredMessage(mimeMessage, flags, date, l);
            simpleStoredMessage.getFlags().add(Flags.Flag.RECENT);
            this.mailMessages.add(simpleStoredMessage);
            int n = this.mailMessages.size();
            List list = this._mailboxListeners;
            synchronized (list) {
                for (int i = 0; i < this._mailboxListeners.size(); ++i) {
                    FolderListener folderListener = (FolderListener)this._mailboxListeners.get(i);
                    folderListener.added(n);
                }
            }
            return l;
        }

        public void setFlags(Flags flags, boolean bl, long l, FolderListener folderListener, boolean bl2) throws FolderException {
            int n = this.getMsn(l);
            SimpleStoredMessage simpleStoredMessage = (SimpleStoredMessage)this.mailMessages.get(n - 1);
            if (bl) {
                simpleStoredMessage.getFlags().add(flags);
            } else {
                simpleStoredMessage.getFlags().remove(flags);
            }
            Long l2 = null;
            if (bl2) {
                l2 = new Long(l);
            }
            this.notifyFlagUpdate(n, simpleStoredMessage.getFlags(), l2, folderListener);
        }

        public void replaceFlags(Flags flags, long l, FolderListener folderListener, boolean bl) throws FolderException {
            int n = this.getMsn(l);
            SimpleStoredMessage simpleStoredMessage = (SimpleStoredMessage)this.mailMessages.get(n - 1);
            simpleStoredMessage.getFlags().remove(MessageFlags.ALL_FLAGS);
            simpleStoredMessage.getFlags().add(flags);
            Long l2 = null;
            if (bl) {
                l2 = new Long(l);
            }
            this.notifyFlagUpdate(n, simpleStoredMessage.getFlags(), l2, folderListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyFlagUpdate(int n, Flags flags, Long l, FolderListener folderListener) {
            List list = this._mailboxListeners;
            synchronized (list) {
                for (int i = 0; i < this._mailboxListeners.size(); ++i) {
                    FolderListener folderListener2 = (FolderListener)this._mailboxListeners.get(i);
                    if (folderListener2 == folderListener) continue;
                    folderListener2.flagsUpdated(n, flags, l);
                }
            }
        }

        public void deleteAllMessages() {
            this.mailMessages.clear();
        }

        public void store(MovingMessage movingMessage) throws Exception {
            this.store(movingMessage.getMessage());
        }

        public void store(MimeMessage mimeMessage) throws Exception {
            Date date = new Date();
            Flags flags = new Flags();
            this.appendMessage(mimeMessage, flags, date);
        }

        public SimpleStoredMessage getMessage(long l) {
            for (int i = 0; i < this.mailMessages.size(); ++i) {
                SimpleStoredMessage simpleStoredMessage = (SimpleStoredMessage)this.mailMessages.get(i);
                if (simpleStoredMessage.getUid() != l) continue;
                return simpleStoredMessage;
            }
            return null;
        }

        public long[] getMessageUids() {
            long[] lArray = new long[this.mailMessages.size()];
            for (int i = 0; i < this.mailMessages.size(); ++i) {
                SimpleStoredMessage simpleStoredMessage = (SimpleStoredMessage)this.mailMessages.get(i);
                lArray[i] = simpleStoredMessage.getUid();
            }
            return lArray;
        }

        private void deleteMessage(int n) {
            this.mailMessages.remove(n - 1);
        }

        public long[] search(SearchTerm searchTerm) {
            ArrayList<SimpleStoredMessage> arrayList = new ArrayList<SimpleStoredMessage>();
            for (int i = 0; i < this.mailMessages.size(); ++i) {
                SimpleStoredMessage simpleStoredMessage = (SimpleStoredMessage)this.mailMessages.get(i);
                if (!searchTerm.match((Message)simpleStoredMessage.getMimeMessage())) continue;
                arrayList.add(simpleStoredMessage);
            }
            long[] lArray = new long[arrayList.size()];
            for (int i = 0; i < lArray.length; ++i) {
                long l;
                SimpleStoredMessage simpleStoredMessage = (SimpleStoredMessage)arrayList.get(i);
                lArray[i] = l = simpleStoredMessage.getUid();
            }
            return lArray;
        }

        public void copyMessage(long l, MailFolder mailFolder) throws FolderException {
            SimpleStoredMessage simpleStoredMessage = this.getMessage(l);
            MimeMessage mimeMessage = null;
            try {
                mimeMessage = new MimeMessage(simpleStoredMessage.getMimeMessage());
            }
            catch (MessagingException messagingException) {
                throw new FolderException("Messaging exception: " + messagingException.getMessage());
            }
            Flags flags = new Flags();
            flags.add(simpleStoredMessage.getFlags());
            Date date = simpleStoredMessage.getInternalDate();
            mailFolder.appendMessage(mimeMessage, flags, date);
        }

        public void expunge() throws FolderException {
            for (int i = 0; i < this.mailMessages.size(); ++i) {
                SimpleStoredMessage simpleStoredMessage = (SimpleStoredMessage)this.mailMessages.get(i);
                if (!simpleStoredMessage.getFlags().contains(Flags.Flag.DELETED)) continue;
                this.expungeMessage(i + 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void expungeMessage(int n) {
            List list = this._mailboxListeners;
            synchronized (list) {
                this.deleteMessage(n);
                for (int i = 0; i < this._mailboxListeners.size(); ++i) {
                    FolderListener folderListener = (FolderListener)this._mailboxListeners.get(i);
                    folderListener.expunged(n);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(FolderListener folderListener) {
            List list = this._mailboxListeners;
            synchronized (list) {
                this._mailboxListeners.add(folderListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(FolderListener folderListener) {
            List list = this._mailboxListeners;
            synchronized (list) {
                this._mailboxListeners.remove(folderListener);
            }
        }
    }

    private class RootFolder
    extends HierarchicalFolder {
        public RootFolder() {
            super(null, "#mail");
        }

        public String getFullName() {
            return this.name;
        }
    }
}

