/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.store;

import com.icegreen.greenmail.mail.MailAddress;
import com.icegreen.greenmail.store.MailMessageAttributes;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;

public class SimpleMessageAttributes
implements MailMessageAttributes {
    private static final String SP = " ";
    private static final String NIL = "NIL";
    private static final String Q = "\"";
    private static final String LB = "(";
    private static final String RB = ")";
    private static final boolean DEBUG = false;
    private static final String MULTIPART = "MULTIPART";
    private static final String MESSAGE = "MESSAGE";
    private int uid;
    private int messageSequenceNumber;
    private Date internalDate;
    private String internalDateString;
    private String bodyStructure;
    private String envelope;
    private int size;
    private int lineCount;
    public MailMessageAttributes[] parts;
    private List headers;
    private String subject;
    private String[] from;
    private String[] sender;
    private String[] replyTo;
    private String[] to;
    private String[] cc;
    private String[] bcc;
    private String[] inReplyTo;
    private String[] date;
    private String[] messageID;
    private String contentType;
    private String primaryType = null;
    private String secondaryType = null;
    private Set parameters;
    private String contentID = null;
    private String contentDesc = null;
    private String contentEncoding = null;
    private String interalDateEnvelopeString = null;
    private Header contentDisposition = null;

    SimpleMessageAttributes() {
    }

    void setAttributesFor(MimeMessage mimeMessage) throws MessagingException {
        try {
            this.internalDate = mimeMessage.getSentDate();
        }
        catch (MessagingException messagingException) {
            this.internalDate = new Date();
        }
        if (null == this.internalDate) {
            this.internalDate = new Date();
        }
        this.internalDateString = new SimpleDateFormat("dd-MMM-yyyy hh:mm:ss Z").format(this.internalDate);
        this.interalDateEnvelopeString = new MailDateFormat().format(this.internalDate);
        this.parseMimePart((MimePart)mimeMessage);
        this.envelope = null;
        this.bodyStructure = null;
    }

    void setUID(int n) {
        this.uid = n;
    }

    void parseMimePart(MimePart mimePart) throws MessagingException {
        this.size = GreenMailUtil.getBody((Part)mimePart).length();
        if (mimePart instanceof MimeMessage) {
            try {
                this.subject = ((MimeMessage)mimePart).getSubject();
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
        try {
            this.from = mimePart.getHeader("From");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        try {
            this.sender = mimePart.getHeader("Sender");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        try {
            this.replyTo = mimePart.getHeader("Reply To");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        try {
            this.to = mimePart.getHeader("To");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        try {
            this.cc = mimePart.getHeader("Cc");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        try {
            this.bcc = mimePart.getHeader("Bcc");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        try {
            this.inReplyTo = mimePart.getHeader("In Reply To");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        try {
            this.date = mimePart.getHeader("Date");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        try {
            this.messageID = mimePart.getHeader("Message-ID");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        String string = null;
        try {
            string = mimePart.getContentType();
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        if (string != null) {
            this.decodeContentType(string);
        }
        try {
            this.contentID = mimePart.getContentID();
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        try {
            this.contentDesc = mimePart.getDescription();
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        try {
            this.contentEncoding = mimePart.getEncoding();
            if (this.contentEncoding == null) {
                this.contentEncoding = "7BIT";
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        try {
            this.contentDisposition = Header.create(mimePart.getHeader("Content-Disposition"));
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        try {
            this.lineCount = this.getLineCount(mimePart);
        }
        catch (MessagingException messagingException) {
            messagingException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.primaryType.equalsIgnoreCase(MULTIPART)) {
            try {
                MimeMultipart mimeMultipart = (MimeMultipart)mimePart.getContent();
                int n = mimeMultipart.getCount();
                this.parts = new SimpleMessageAttributes[n];
                for (int i = 0; i < n; ++i) {
                    BodyPart bodyPart = mimeMultipart.getBodyPart(i);
                    if (!(bodyPart instanceof MimePart)) continue;
                    SimpleMessageAttributes simpleMessageAttributes = new SimpleMessageAttributes();
                    simpleMessageAttributes.parseMimePart((MimePart)bodyPart);
                    this.parts[i] = simpleMessageAttributes;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (this.primaryType.equalsIgnoreCase("message") && !this.secondaryType.equalsIgnoreCase("RFC822")) {
            System.out.println("Unknown subtype of message encountered.");
        }
    }

    private int getLineCount(MimePart mimePart) throws MessagingException {
        return GreenMailUtil.getLineCount(GreenMailUtil.getBody((Part)mimePart));
    }

    String parseEnvelope() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("(\"" + this.interalDateEnvelopeString + Q + SP);
        if (this.subject != null && !this.subject.equals("")) {
            arrayList.add(Q + this.subject + Q + SP);
        } else {
            arrayList.add("NIL ");
        }
        if (this.from != null && this.from.length > 0) {
            arrayList.add(LB);
            for (n = 0; n < this.from.length; ++n) {
                arrayList.add(this.parseAddress(this.from[n]));
            }
            arrayList.add(RB);
        } else {
            arrayList.add(NIL);
        }
        arrayList.add(SP);
        if (this.sender != null && this.sender.length > 0) {
            if (this.sender[0].indexOf("@") == -1) {
                arrayList.add(LB + (String)arrayList.get(3) + RB);
            } else {
                arrayList.add(LB);
                for (n = 0; n < this.sender.length; ++n) {
                    arrayList.add(this.parseAddress(this.sender[n]));
                }
                arrayList.add(RB);
            }
        } else if (this.from != null && this.from.length > 0) {
            arrayList.add(LB + (String)arrayList.get(3) + RB);
        } else {
            arrayList.add(NIL);
        }
        arrayList.add(SP);
        if (this.replyTo != null && this.replyTo.length > 0) {
            if (this.replyTo[0].indexOf("@") == -1) {
                arrayList.add(LB + (String)arrayList.get(3) + RB);
            } else {
                arrayList.add(LB);
                for (n = 0; n < this.replyTo.length; ++n) {
                    arrayList.add(this.parseAddress(this.replyTo[n]));
                }
                arrayList.add(RB);
            }
        } else if (this.from != null && this.from.length > 0) {
            arrayList.add(LB + (String)arrayList.get(3) + RB);
        } else {
            arrayList.add(NIL);
        }
        arrayList.add(SP);
        if (this.to != null && this.to.length > 0) {
            arrayList.add(LB);
            for (n = 0; n < this.to.length; ++n) {
                arrayList.add(this.parseAddress(this.to[n]));
            }
            arrayList.add(RB);
        } else {
            arrayList.add(NIL);
        }
        arrayList.add(SP);
        if (this.cc != null && this.cc.length > 0) {
            arrayList.add(LB);
            for (n = 0; n < this.cc.length; ++n) {
                arrayList.add(this.parseAddress(this.cc[n]));
            }
            arrayList.add(RB);
        } else {
            arrayList.add(NIL);
        }
        arrayList.add(SP);
        if (this.bcc != null && this.bcc.length > 0) {
            arrayList.add(LB);
            for (n = 0; n < this.bcc.length; ++n) {
                arrayList.add(this.parseAddress(this.bcc[n]));
            }
            arrayList.add(RB);
        } else {
            arrayList.add(NIL);
        }
        arrayList.add(SP);
        if (this.inReplyTo != null && this.inReplyTo.length > 0) {
            arrayList.add(this.inReplyTo[0]);
        } else {
            arrayList.add(NIL);
        }
        arrayList.add(SP);
        if (this.messageID != null && this.messageID.length > 0) {
            arrayList.add(Q + this.messageID[0] + Q);
        } else {
            arrayList.add(NIL);
        }
        arrayList.add(RB);
        StringBuffer stringBuffer = new StringBuffer(16 * arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuffer.append((String)arrayList.get(i));
        }
        return stringBuffer.toString();
    }

    String parseAddress(String string) {
        int n = string.indexOf(",");
        StringBuffer stringBuffer = new StringBuffer();
        if (n == -1) {
            stringBuffer.append(LB);
            InternetAddress internetAddress = null;
            try {
                internetAddress = new InternetAddress(string);
            }
            catch (AddressException addressException) {
                return null;
            }
            String string2 = internetAddress.getPersonal();
            if (string2 != null && !string2.equals("")) {
                stringBuffer.append(Q + string2 + Q);
            } else {
                stringBuffer.append(NIL);
            }
            stringBuffer.append(SP);
            stringBuffer.append(NIL);
            stringBuffer.append(SP);
            try {
                MailAddress mailAddress = new MailAddress(internetAddress.getAddress());
                stringBuffer.append(Q + mailAddress.getUser() + Q);
                stringBuffer.append(SP);
                stringBuffer.append(Q + mailAddress.getHost() + Q);
            }
            catch (Exception exception) {
                stringBuffer.append("NIL NIL");
            }
            stringBuffer.append(RB);
        } else {
            stringBuffer.append(this.parseAddress(string.substring(0, n)));
            stringBuffer.append(SP);
            stringBuffer.append(this.parseAddress(string.substring(n + 1)));
        }
        return stringBuffer.toString();
    }

    void decodeContentType(String string) {
        int n = string.indexOf("/");
        if (n == -1) {
            return;
        }
        this.primaryType = string.substring(0, n).trim();
        int n2 = string.indexOf(";");
        if (n2 == -1) {
            this.secondaryType = string.substring(n + 1).trim();
            return;
        }
        this.secondaryType = string.substring(n + 1, n2).trim();
        Header header = new Header(string);
        this.parameters = header.getParams();
    }

    String parseBodyFields() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getParameters(stringBuffer);
        stringBuffer.append(SP);
        if (this.contentID == null) {
            stringBuffer.append(NIL);
        } else {
            stringBuffer.append(Q + this.contentID + Q);
        }
        stringBuffer.append(SP);
        if (this.contentDesc == null) {
            stringBuffer.append(NIL);
        } else {
            stringBuffer.append(Q + this.contentDesc + Q);
        }
        stringBuffer.append(SP);
        if (this.contentEncoding == null) {
            stringBuffer.append(NIL);
        } else {
            stringBuffer.append(Q + this.contentEncoding + Q);
        }
        stringBuffer.append(SP);
        stringBuffer.append(this.size);
        return stringBuffer.toString();
    }

    private void getParameters(StringBuffer stringBuffer) {
        if (this.parameters == null || this.parameters.isEmpty()) {
            stringBuffer.append(NIL);
        } else {
            stringBuffer.append(LB);
            Iterator iterator = this.parameters.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
            }
            stringBuffer.append(RB);
        }
    }

    String parseBodyStructure(boolean bl) {
        try {
            String string = this.parseBodyFields();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(LB);
            if (this.primaryType.equalsIgnoreCase("Text")) {
                stringBuffer.append("\"TEXT\" \"");
                stringBuffer.append(this.secondaryType.toUpperCase());
                stringBuffer.append("\" ");
                stringBuffer.append(string);
                stringBuffer.append(SP);
                stringBuffer.append(this.lineCount);
            } else if (this.primaryType.equalsIgnoreCase(MESSAGE) && this.secondaryType.equalsIgnoreCase("rfc822")) {
                stringBuffer.append("\"MESSAGE\" \"RFC822\" ");
                stringBuffer.append(string + SP);
                stringBuffer.append(this.parts[0].getEnvelope() + SP);
                stringBuffer.append(this.parts[0].getBodyStructure(false) + SP);
                stringBuffer.append(this.lineCount);
            } else if (this.primaryType.equalsIgnoreCase(MULTIPART)) {
                for (int i = 0; i < this.parts.length; ++i) {
                    stringBuffer.append(this.parts[i].getBodyStructure(bl));
                }
                stringBuffer.append(" \"" + this.secondaryType + Q);
            } else {
                stringBuffer.append(Q);
                stringBuffer.append(this.primaryType.toUpperCase());
                stringBuffer.append(Q);
                stringBuffer.append(" \"");
                stringBuffer.append(this.secondaryType.toUpperCase());
                stringBuffer.append(Q);
                stringBuffer.append(SP);
                this.getParameters(stringBuffer);
                stringBuffer.append(SP);
                stringBuffer.append(NIL);
                stringBuffer.append(SP);
                if (null != this.contentDesc) {
                    stringBuffer.append(Q);
                    stringBuffer.append(this.contentDesc);
                    stringBuffer.append(Q);
                } else {
                    stringBuffer.append(NIL);
                }
                stringBuffer.append(SP);
                if (null != this.contentEncoding) {
                    stringBuffer.append(Q);
                    stringBuffer.append(this.contentEncoding);
                    stringBuffer.append(Q);
                } else {
                    stringBuffer.append(NIL);
                }
                stringBuffer.append(SP);
                stringBuffer.append(this.size);
            }
            if (bl) {
                if (this.primaryType.equalsIgnoreCase(MULTIPART)) {
                    stringBuffer.append(SP);
                    this.getParameters(stringBuffer);
                    stringBuffer.append(SP);
                    if (null != this.contentDisposition) {
                        stringBuffer.append(this.contentDisposition);
                    } else {
                        stringBuffer.append(NIL);
                    }
                    stringBuffer.append(SP);
                    stringBuffer.append(NIL);
                } else {
                    stringBuffer.append(SP);
                    stringBuffer.append(NIL);
                    stringBuffer.append(SP);
                    if (null != this.contentDisposition) {
                        stringBuffer.append(this.contentDisposition);
                    } else {
                        stringBuffer.append(NIL);
                    }
                    stringBuffer.append(SP);
                    stringBuffer.append(NIL);
                }
            }
            stringBuffer.append(RB);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Exception in parseBodyStructure");
        }
    }

    public int getMessageSequenceNumber() {
        return this.messageSequenceNumber;
    }

    void setMessageSequenceNumber(int n) {
        this.messageSequenceNumber = n;
    }

    public int getUID() {
        return this.uid;
    }

    public Date getInternalDate() {
        return this.internalDate;
    }

    public String getInternalDateAsString() {
        return this.internalDateString;
    }

    public int getSize() {
        return this.size;
    }

    public String getEnvelope() {
        return this.parseEnvelope();
    }

    public String getBodyStructure(boolean bl) {
        return this.parseBodyStructure(bl);
    }

    private static class Header {
        String value;
        Set params = null;

        public Header(String string) {
            String[] stringArray = string.split(";");
            this.value = stringArray[0];
            if (0 != stringArray.length) {
                this.params = new HashSet();
                for (int i = 1; i < stringArray.length; ++i) {
                    String string2 = stringArray[i].trim();
                    int n = string2.indexOf("=");
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1, string2.length());
                    string2 = SimpleMessageAttributes.Q + this.strip(string3) + SimpleMessageAttributes.Q + SimpleMessageAttributes.SP + SimpleMessageAttributes.Q + this.strip(string4) + SimpleMessageAttributes.Q;
                    this.params.add(string2);
                }
            }
        }

        public Set getParams() {
            return this.params;
        }

        private String strip(String string) {
            return string.replaceAll("\\\"", "");
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (null == this.params) {
                stringBuffer.append(SimpleMessageAttributes.Q + this.value + SimpleMessageAttributes.Q);
            } else {
                stringBuffer.append(SimpleMessageAttributes.LB);
                stringBuffer.append(SimpleMessageAttributes.Q + this.value + SimpleMessageAttributes.Q + SimpleMessageAttributes.SP);
                stringBuffer.append(SimpleMessageAttributes.LB);
                int n = 0;
                Iterator iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    if (n++ > 0) {
                        stringBuffer.append(SimpleMessageAttributes.SP);
                    }
                    String string = (String)iterator.next();
                    stringBuffer.append(string);
                }
                stringBuffer.append(SimpleMessageAttributes.RB);
                stringBuffer.append(SimpleMessageAttributes.RB);
            }
            return stringBuffer.toString();
        }

        public static Header create(String[] stringArray) {
            if (null == stringArray || 0 == stringArray.length) {
                return null;
            }
            if (stringArray.length > 1) {
                throw new IllegalArgumentException("Header creation assumes only one occurrence of header");
            }
            return new Header(stringArray[0]);
        }
    }
}

