/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.user;

import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.mail.MovingMessage;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserException;
import java.io.Serializable;
import javax.mail.internet.MimeMessage;

public class UserImpl
implements GreenMailUser,
Serializable {
    String email;
    String login;
    String password;
    private ImapHostManager imapHostManager;

    public UserImpl(String string, String string2, String string3, ImapHostManager imapHostManager) {
        this.email = string;
        this.login = string2;
        this.password = string3;
        this.imapHostManager = imapHostManager;
    }

    public void create() throws UserException {
        try {
            this.imapHostManager.createPrivateMailAccount(this);
        }
        catch (Exception exception) {
            throw new UserException(exception);
        }
    }

    public void delete() throws UserException {
    }

    public void deliver(MovingMessage movingMessage) throws UserException {
        try {
            this.imapHostManager.getInbox(this).store(movingMessage);
        }
        catch (Exception exception) {
            throw new UserException(exception);
        }
    }

    public void deliver(MimeMessage mimeMessage) throws UserException {
        try {
            this.imapHostManager.getInbox(this).store(mimeMessage);
        }
        catch (Exception exception) {
            throw new UserException(exception);
        }
    }

    public String getEmail() {
        return this.email;
    }

    public String getLogin() {
        if (null == this.login) {
            return this.email;
        }
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void authenticate(String string) throws UserException {
        if (!this.password.equals(string)) {
            throw new UserException("Invalid password");
        }
    }

    public String getQualifiedMailboxName() {
        return String.valueOf(this.email.hashCode());
    }

    public int hashCode() {
        return this.email.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof UserImpl) || null == object) {
            return false;
        }
        UserImpl userImpl = (UserImpl)object;
        return this.email.equals(userImpl.email);
    }
}

