/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.icegreen.greenmail.Managers;
import com.icegreen.greenmail.imap.ImapServer;
import com.icegreen.greenmail.pop3.Pop3Server;
import com.icegreen.greenmail.smtp.SmtpManager;
import com.icegreen.greenmail.smtp.SmtpServer;
import com.icegreen.greenmail.store.SimpleStoredMessage;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserException;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.icegreen.greenmail.util.ServerSetup;
import com.icegreen.greenmail.util.ServerSetupTest;
import com.icegreen.greenmail.util.Service;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.mail.internet.MimeMessage;

public class GreenMail {
    Managers managers = new Managers();
    HashMap services = new HashMap();

    public GreenMail() {
        this(ServerSetupTest.ALL);
    }

    public GreenMail(ServerSetup serverSetup) {
        this(new ServerSetup[]{serverSetup});
    }

    public GreenMail(ServerSetup[] serverSetupArray) {
        for (int i = 0; i < serverSetupArray.length; ++i) {
            ServerSetup serverSetup = serverSetupArray[i];
            if (this.services.containsKey(serverSetup.getProtocol())) {
                throw new IllegalArgumentException("Server '" + serverSetup.getProtocol() + "' was found at least twice in the array");
            }
            String string = serverSetup.getProtocol();
            if (string.startsWith("smtp")) {
                this.services.put(string, new SmtpServer(serverSetup, this.managers));
                continue;
            }
            if (string.startsWith("pop3")) {
                this.services.put(string, new Pop3Server(serverSetup, this.managers));
                continue;
            }
            if (!string.startsWith("imap")) continue;
            this.services.put(string, new ImapServer(serverSetup, this.managers));
        }
    }

    public synchronized void start() {
        Iterator iterator = this.services.values().iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            service.startService(null);
        }
    }

    public synchronized void stop() {
        Iterator iterator = this.services.values().iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            service.stopService(null);
        }
    }

    public SmtpServer getSmtp() {
        return (SmtpServer)this.services.get("smtp");
    }

    public ImapServer getImap() {
        return (ImapServer)this.services.get("imap");
    }

    public Pop3Server getPop3() {
        return (Pop3Server)this.services.get("pop3");
    }

    public SmtpServer getSmtps() {
        return (SmtpServer)this.services.get("smtps");
    }

    public ImapServer getImaps() {
        return (ImapServer)this.services.get("imaps");
    }

    public Pop3Server getPop3s() {
        return (Pop3Server)this.services.get("pop3s");
    }

    public Managers getManagers() {
        return this.managers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForIncomingEmail(long l, int n) throws InterruptedException {
        SmtpManager.WaitObject waitObject = this.managers.getSmtpManager().createAndAddNewWaitObject(n);
        if (null == waitObject) {
            return true;
        }
        SmtpManager.WaitObject waitObject2 = waitObject;
        synchronized (waitObject2) {
            long l2 = System.currentTimeMillis();
            while (!waitObject.isArrived()) {
                waitObject.wait(l);
                if (System.currentTimeMillis() - l2 <= l) continue;
                return false;
            }
        }
        return true;
    }

    public boolean waitForIncomingEmail(int n) throws InterruptedException {
        return this.waitForIncomingEmail(5000L, n);
    }

    public MimeMessage[] getReceivedMessages() {
        List list = this.managers.getImapHostManager().getAllMessages();
        MimeMessage[] mimeMessageArray = new MimeMessage[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            SimpleStoredMessage simpleStoredMessage = (SimpleStoredMessage)list.get(i);
            mimeMessageArray[i] = simpleStoredMessage.getMimeMessage();
        }
        return mimeMessageArray;
    }

    public GreenMailUser setUser(String string, String string2) {
        return this.setUser(string, string, string2);
    }

    public GreenMailUser setUser(String string, String string2, String string3) {
        GreenMailUser greenMailUser = this.managers.getUserManager().getUser(string);
        if (null == greenMailUser) {
            try {
                greenMailUser = this.managers.getUserManager().createUser(string, string2, string3);
            }
            catch (UserException userException) {
                throw new RuntimeException(userException);
            }
        } else {
            greenMailUser.setPassword(string3);
        }
        return greenMailUser;
    }

    public void setUsers(Properties properties) {
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = properties.getProperty(string);
            this.setUser(string, string, string2);
        }
    }

    public GreenMailUtil util() {
        return GreenMailUtil.instance();
    }
}

