/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.icegreen.greenmail.util.DummySSLSocketFactory;
import com.icegreen.greenmail.util.ServerSetup;
import com.icegreen.greenmail.util.ServerSetupTest;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.Random;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class GreenMailUtil {
    private static int generateCount = 0;
    private static final String generateSet = "abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPRSTUVWXYZ23456789";
    private static final int generateSetSize = "abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPRSTUVWXYZ23456789".length();
    private static GreenMailUtil instance = new GreenMailUtil();

    private GreenMailUtil() {
    }

    public static GreenMailUtil instance() {
        return instance;
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = inputStream.read(byArray)) > -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }

    public static MimeMessage newMimeMessage(InputStream inputStream) {
        try {
            return new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), inputStream);
        }
        catch (MessagingException messagingException) {
            throw new RuntimeException(messagingException);
        }
    }

    public static MimeMessage newMimeMessage(String string) throws MessagingException {
        try {
            byte[] byArray = string.getBytes("US-ASCII");
            return GreenMailUtil.newMimeMessage(new ByteArrayInputStream(byArray));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static boolean hasNonTextAttachments(Part part) {
        try {
            Object object = part.getContent();
            if (object instanceof MimeMultipart) {
                MimeMultipart mimeMultipart = (MimeMultipart)object;
                for (int i = 0; i < mimeMultipart.getCount(); ++i) {
                    BodyPart bodyPart = mimeMultipart.getBodyPart(i);
                    if (!GreenMailUtil.hasNonTextAttachments((Part)bodyPart)) continue;
                    return true;
                }
                return false;
            }
            return !part.getContentType().trim().toLowerCase().startsWith("text");
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static int getLineCount(String string) {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        int n = 0;
        try {
            while (bufferedReader.readLine() != null) {
                ++n;
            }
            return n;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String getBody(Part part) {
        String string = GreenMailUtil.getWholeMessage(part);
        int n = string.indexOf("\r\n\r\n");
        return string.substring(n + 4, string.length());
    }

    public static String getHeaders(Part part) {
        String string = GreenMailUtil.getWholeMessage(part);
        int n = string.indexOf("\r\n\r\n");
        return string.substring(0, n);
    }

    public static String getWholeMessage(Part part) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            part.writeTo((OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toString("US-ASCII").trim();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static byte[] getBodyAsBytes(Part part) {
        return GreenMailUtil.getBody(part).getBytes();
    }

    public static byte[] getHeaderAsBytes(Part part) {
        return GreenMailUtil.getHeaders(part).getBytes();
    }

    public static String toString(Part part) {
        return GreenMailUtil.getWholeMessage(part);
    }

    public static String random() {
        Random random = new Random();
        int n = random.nextInt(3) + 5;
        return GreenMailUtil.random(n);
    }

    public static String random(int n) {
        Random random = new Random();
        StringBuffer stringBuffer = new StringBuffer();
        while (n > 0) {
            int n2 = (random.nextInt(generateSetSize) + ++generateCount) % generateSetSize;
            stringBuffer.append(generateSet.charAt(n2));
            --n;
        }
        return stringBuffer.toString();
    }

    public static void sendTextEmailTest(String string, String string2, String string3, String string4) {
        try {
            GreenMailUtil.sendTextEmail(string, string2, string3, string4, ServerSetupTest.SMTP);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static void sendTextEmailSecureTest(String string, String string2, String string3, String string4) {
        try {
            GreenMailUtil.sendTextEmail(string, string2, string3, string4, ServerSetupTest.SMTPS);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static String getAddressList(Address[] addressArray) {
        if (null == addressArray) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < addressArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(addressArray[i].toString());
        }
        return stringBuffer.toString();
    }

    private static void sendTextEmail(String string, String string2, String string3, String string4, ServerSetup serverSetup) {
        try {
            Session session = GreenMailUtil.getSession(serverSetup);
            Address[] addressArray = new Address[]{};
            addressArray = new InternetAddress[]{new InternetAddress(string)};
            InternetAddress[] internetAddressArray = new InternetAddress[]{new InternetAddress(string2)};
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setSubject(string3);
            mimeMessage.setFrom((Address)internetAddressArray[0]);
            mimeMessage.setText(string4);
            Transport.send((Message)mimeMessage, (Address[])addressArray);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static Session getSession(ServerSetup serverSetup) {
        Properties properties = new Properties();
        properties.put("mail.smtps.starttls.enable", Boolean.TRUE);
        if (serverSetup.isSecure()) {
            properties.setProperty("mail.smtp.socketFactory.class", DummySSLSocketFactory.class.getName());
        }
        properties.setProperty("mail.transport.protocol", serverSetup.getProtocol());
        properties.setProperty("mail.smtp.port", String.valueOf(serverSetup.getPort()));
        properties.setProperty("mail.smtps.port", String.valueOf(serverSetup.getPort()));
        Session session = Session.getInstance((Properties)properties, null);
        return session;
    }

    public static void sendAttachmentEmail(String string, String string2, String string3, String string4, final byte[] byArray, final String string5, final String string6, String string7, ServerSetup serverSetup) throws MessagingException, IOException {
        Session session = GreenMailUtil.getSession(serverSetup);
        InternetAddress[] internetAddressArray = new InternetAddress[]{new InternetAddress(string)};
        InternetAddress[] internetAddressArray2 = new InternetAddress[]{new InternetAddress(string2)};
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setSubject(string3);
        mimeMessage.setFrom((Address)internetAddressArray2[0]);
        MimeMultipart mimeMultipart = new MimeMultipart();
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        mimeBodyPart.setText(string4);
        MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart2);
        DataSource dataSource = new DataSource(){

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(byArray);
            }

            public OutputStream getOutputStream() throws IOException {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(byArray);
                return byteArrayOutputStream;
            }

            public String getContentType() {
                return string5;
            }

            public String getName() {
                return string6;
            }
        };
        mimeBodyPart2.setDataHandler(new DataHandler(dataSource));
        mimeBodyPart2.setFileName(string6);
        mimeBodyPart2.setDescription(string7);
        mimeMessage.setContent((Multipart)mimeMultipart);
        Transport.send((Message)mimeMessage, (Address[])internetAddressArray);
    }
}

