/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.icegreen.greenmail.AbstractServer;
import com.icegreen.greenmail.util.DummySSLSocketFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;

public class Retriever {
    public static final String PROTOCOL_POP3 = "pop3";
    public static final String PROTOCOL_POP3S = "pop3s";
    public static final String PROTOCOL_IMAP = "imap";
    public static final String PROTOCOL_IMAPS = "imaps";
    private String protocol;
    private int port;
    private String host;
    private Store store = null;

    public Retriever(AbstractServer abstractServer) {
        this.protocol = abstractServer.getProtocol();
        this.port = abstractServer.getPort();
        this.host = abstractServer.getBindTo();
    }

    public Message[] getMessages(String string) throws Exception {
        return this.getMessages(string, string);
    }

    public Message[] getMessages(String string, String string2) throws Exception {
        Properties properties = new Properties();
        if (this.protocol.endsWith("s")) {
            properties.put("mail.pop3.starttls.enable", Boolean.TRUE);
            properties.put("mail.imap.starttls.enable", Boolean.TRUE);
        }
        properties.setProperty("mail.imaps.socketFactory.class", DummySSLSocketFactory.class.getName());
        properties.setProperty("mail.pop3s.socketFactory.class", DummySSLSocketFactory.class.getName());
        properties.setProperty("mail.imap.socketFactory.fallback", "false");
        properties.setProperty("mail.imaps.socketFactory.fallback", "false");
        properties.setProperty("mail.pop3s.socketFactory.fallback", "false");
        properties.setProperty("mail.imap.connectiontimeout", "15000");
        properties.setProperty("mail.imaps.connectiontimeout", "15000");
        properties.setProperty("mail.pop3.connectiontimeout", "15000");
        properties.setProperty("mail.pop3s.connectiontimeout", "15000");
        properties.setProperty("mail.imap.timeout", "15000");
        properties.setProperty("mail.imaps.timeout", "15000");
        properties.setProperty("mail.pop3.timeout", "15000");
        properties.setProperty("mail.pop3s.timeout", "15000");
        Session session = Session.getInstance((Properties)properties, null);
        this.store = session.getStore(this.protocol);
        this.store.connect(this.host, this.port, string, string2);
        Folder folder = this.store.getFolder("INBOX");
        return this.getMessages(folder).toArray(new Message[0]);
    }

    public void logout() {
        try {
            this.store.close();
        }
        catch (MessagingException messagingException) {
            throw new RuntimeException(messagingException);
        }
    }

    private List getMessages(Folder folder) throws MessagingException {
        int n;
        Message[] messageArray;
        ArrayList<Message> arrayList = new ArrayList<Message>();
        if ((folder.getType() & 1) != 0) {
            if (!folder.isOpen()) {
                folder.open(1);
            }
            messageArray = folder.getMessages();
            for (n = 0; n < messageArray.length; ++n) {
                arrayList.add(messageArray[n]);
            }
        }
        if ((folder.getType() & 2) != 0) {
            messageArray = folder.list();
            for (n = 0; n < messageArray.length; ++n) {
                arrayList.addAll(this.getMessages((Folder)messageArray[n]));
            }
        }
        return arrayList;
    }
}

