/*
 * Decompiled with CFR 0.152.
 */
package com.alan344happyframework.config;

import com.alan344happyframework.exception.BizException;
import com.alan344happyframework.response.AbstractResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.UndeclaredThrowableException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
public class CommonControllerAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(CommonControllerAdvice.class);
    @Autowired
    private ObjectMapper objectMapper;
    private static String[] SWAGGER_URLS = new String[]{"/configuration/ui", "/swagger-resources", "/v2/api-docs", "/configuration/security"};

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public Object handleMissingServletRequestParameterException(MissingServletRequestParameterException ex) {
        log.error("\u7f3a\u5c11\u8bf7\u6c42\u53c2\u6570", (Throwable)ex);
        return new AbstractResponse<Object>("required_parameter_is_not_present"){};
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public Object handleHttpMessageNotReadableException(HttpMessageNotReadableException ex) {
        log.error("\u53c2\u6570\u89e3\u6790\u5931\u8d25", (Throwable)ex);
        return new AbstractResponse<Object>("could_not_read_json"){};
    }

    @ExceptionHandler(value={BizException.class})
    public Object handleBizExec(HttpServletRequest request, BizException ex) {
        return new AbstractResponse<Object>(ex.getErrorCode(), ex.getMessage()){};
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Object handleMethodArgumentNotValidException(HttpServletRequest request, MethodArgumentNotValidException ex) {
        return new AbstractResponse<Object>(((ObjectError)ex.getBindingResult().getAllErrors().get(0)).getDefaultMessage()){};
    }

    @ExceptionHandler(value={TypeMismatchException.class})
    public AbstractResponse handleTypeMismatchException(TypeMismatchException ex) {
        return new AbstractResponse<Object>("\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d"){};
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public AbstractResponse<String> handleHttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException ex) {
        return new AbstractResponse<String>(0, ex.getMessage()){};
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public AbstractResponse<String> handleHttpRequestMethodNotSupportedException(IllegalArgumentException ex) {
        return new AbstractResponse<String>(0, ex.getMessage()){};
    }

    @ExceptionHandler(value={BindException.class})
    public Object bindExceptionException(HttpServletRequest request, BindException ex) {
        return new AbstractResponse<Object>(((ObjectError)ex.getAllErrors().get(0)).getDefaultMessage()){};
    }

    @ExceptionHandler(value={UndeclaredThrowableException.class})
    public Object handleUndeclaredThrowableException(HttpServletRequest request, UndeclaredThrowableException ex) {
        log.error("error", (Throwable)ex);
        Throwable cause = ex.getUndeclaredThrowable().getCause();
        if (cause instanceof BizException) {
            BizException exception = (BizException)cause;
            return new AbstractResponse<Object>(0, exception.getMessage()){};
        }
        return new AbstractResponse<Object>(0, ex.getMessage()){};
    }

    @ExceptionHandler(value={RuntimeException.class})
    public Object handleException(HttpServletRequest request, RuntimeException ex) {
        log.error("error", (Throwable)ex);
        return new AbstractResponse<Object>(500, "\u7cfb\u7edf\u5f02\u5e38"){};
    }

    public boolean supports(MethodParameter methodParameter, Class<? extends HttpMessageConverter<?>> aClass) {
        return true;
    }

    public Object beforeBodyWrite(@Nullable Object o, MethodParameter methodParameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        if (CommonControllerAdvice.contains(serverHttpRequest.getURI().getPath(), SWAGGER_URLS) || o instanceof AbstractResponse) {
            return o;
        }
        AbstractResponse<Object> response = new AbstractResponse<Object>(){};
        response.setResultCode(Integer.valueOf(200));
        response.setData(o);
        if (o instanceof String) {
            try {
                return this.objectMapper.writeValueAsString((Object)response);
            }
            catch (JsonProcessingException e) {
                log.error("jackson\u89e3\u6790\u51fa\u9519", (Throwable)e);
            }
        }
        return response;
    }

    private static boolean contains(String source, String[] urls) {
        for (String url : urls) {
            if (!source.contains(url)) continue;
            return true;
        }
        return false;
    }
}

