/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.jwt;

import icu.easyj.jwt.JwtConstant;
import icu.easyj.jwt.JwtInfo;
import java.util.Date;
import java.util.Map;
import org.springframework.util.Assert;

public interface IJwtBuilder {
    public String create(String var1, Map<String, Object> var2, Date var3, Date var4);

    default public String create(String jwtId, Map<String, Object> claims, Date issuedAt, int expiredTime) {
        if (issuedAt == null) {
            issuedAt = new Date();
        }
        Date expiresAt = null;
        if (expiredTime > 0) {
            expiresAt = new Date(issuedAt.getTime() + (long)(expiredTime * 1000));
        }
        return this.create(jwtId, claims, issuedAt, expiresAt);
    }

    default public String create(JwtInfo jwtInfo) {
        Assert.notNull((Object)jwtInfo, (String)"'jwtInfo' must be not null");
        if (jwtInfo.getIssuedAt() == null) {
            jwtInfo.setIssuedAt(new Date());
        }
        int expiredTime = 0;
        if (jwtInfo.getExpiresAt() != null) {
            expiredTime = (int)((jwtInfo.getExpiresAt().getTime() - jwtInfo.getIssuedAt().getTime()) / 1000L);
        }
        return this.create(jwtInfo.getJwtId(), jwtInfo.getClaims(), jwtInfo.getIssuedAt(), expiredTime);
    }

    default public String create(String jwtId, Map<String, Object> claims, Date issuedAt) {
        return this.create(jwtId, claims, issuedAt, JwtConstant.DEFAULT_EXPIRES_AT);
    }

    default public String create(String jwtId, Map<String, Object> claims, int expiredTime) {
        return this.create(jwtId, claims, new Date(), expiredTime);
    }

    default public String create(String jwtId, Map<String, Object> claims) {
        return this.create(jwtId, claims, new Date(), JwtConstant.DEFAULT_EXPIRES_AT);
    }
}

