/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.jwt;

import icu.easyj.core.convert.ConvertUtils;
import icu.easyj.core.util.MapUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.springframework.lang.Nullable;

public class JwtInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String jwtId;
    private Map<String, Object> claims;
    private Date issuedAt;
    private Date expiresAt;

    public JwtInfo() {
    }

    public JwtInfo(String jwtId, Map<String, Object> claims, Date issuedAt, Date expiresAt) {
        this.jwtId = jwtId;
        this.claims = claims;
        this.issuedAt = issuedAt;
        this.expiresAt = expiresAt;
    }

    @Nullable
    public Object getClaims(String key) {
        if (MapUtils.isEmpty(this.claims)) {
            return null;
        }
        return this.claims.get(key);
    }

    @Nullable
    public <T> T getClaims(String key, Class<T> targetClass) {
        if (MapUtils.isEmpty(this.claims)) {
            return null;
        }
        return (T)ConvertUtils.convert((Object)this.claims.get(key), targetClass);
    }

    public String getJwtId() {
        return this.jwtId;
    }

    public void setJwtId(String jwtId) {
        this.jwtId = jwtId;
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public void setClaims(Map<String, Object> claims) {
        this.claims = claims;
    }

    public Date getIssuedAt() {
        return this.issuedAt;
    }

    public void setIssuedAt(Date issuedAt) {
        this.issuedAt = issuedAt;
    }

    public Date getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(Date expiresAt) {
        this.expiresAt = expiresAt;
    }
}

