/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.jwt.impls;

import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.jwt.JWT;
import cn.hutool.jwt.JWTValidator;
import cn.hutool.jwt.signers.JWTSigner;
import cn.hutool.jwt.signers.JWTSignerUtil;
import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.util.MapUtils;
import icu.easyj.jwt.IJwt;
import icu.easyj.jwt.JwtInfo;
import icu.easyj.jwt.JwtUtils;
import icu.easyj.jwt.SecretKeyUtils;
import java.security.Key;
import java.util.Date;
import java.util.Map;
import org.springframework.util.Assert;

@LoadLevel(name="hutool", order=100)
public class HutoolJwt
implements IJwt {
    private final JWTSigner signer;

    public HutoolJwt(JWTSigner signer) {
        Assert.notNull((Object)signer, (String)"'signer' must be not null");
        this.signer = signer;
    }

    public HutoolJwt(String algorithmId, Key secretKey) {
        Assert.notNull((Object)algorithmId, (String)"'algorithmId' must be not null");
        Assert.notNull((Object)secretKey, (String)"'secretKey' must be not null");
        this.signer = JWTSignerUtil.createSigner((String)algorithmId, (Key)secretKey);
    }

    public HutoolJwt(String algorithmId, String secretKeyStr, String secretKeyAlgorithm) {
        Assert.notNull((Object)algorithmId, (String)"'algorithmId' must be not null");
        Assert.notNull((Object)secretKeyStr, (String)"'secretKeyStr' must be not null");
        Assert.notNull((Object)secretKeyAlgorithm, (String)"'secretKeyAlgorithm' must be not null");
        Key secretKey = SecretKeyUtils.generate(secretKeyStr, secretKeyAlgorithm);
        this.signer = JWTSignerUtil.createSigner((String)algorithmId, (Key)secretKey);
    }

    @Override
    public String create(String jwtId, Map<String, Object> claims, Date issuedAt, Date expiresAt) {
        JWT jwt = JWT.create();
        if (jwtId != null) {
            jwt.setJWTId(jwtId);
        }
        if (MapUtils.isNotEmpty(claims)) {
            jwt.addPayloads(claims);
        }
        if (issuedAt == null) {
            issuedAt = new Date();
        }
        jwt.setIssuedAt(issuedAt);
        if (expiresAt != null) {
            if (expiresAt.compareTo(issuedAt) <= 0) {
                throw new IllegalArgumentException("\u8fc7\u671f\u65f6\u95f4 \u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e \u7b7e\u53d1\u65f6\u95f4\uff1a");
            }
            jwt.setExpiresAt(expiresAt);
        }
        return jwt.sign(this.signer);
    }

    @Override
    public JwtInfo parse(String jwtStr, long leeway) {
        JWT jwt = JWT.create().parse(jwtStr);
        jwt.setSigner(this.signer);
        if (!jwt.verify()) {
            throw new RuntimeException("JWT\u7b7e\u540d\u65e0\u6548");
        }
        JWTValidator.of((JWT)jwt).validateDate((Date)DateUtil.date(), leeway);
        JSONObject claims = jwt.getPayloads();
        String jwtId = (String)claims.get((Object)"jti", String.class);
        Date issuedAt = new Date(claims.getDate((Object)"iat").getTime());
        Date expiresAt = new Date(claims.getDate((Object)"exp").getTime());
        JwtUtils.removeSpecialClaims((Map<String, Object>)claims);
        return new JwtInfo(jwtId, (Map<String, Object>)claims, issuedAt, expiresAt);
    }
}

