/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.simplify;

import icu.easyj.maven.plugin.mojo.utils.MavenXpp3Writer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractSimplifyPomMojo
extends AbstractMojo {
    protected static final int POM_WRITER_SIZE = 4096;
    @Parameter(defaultValue="${project.basedir}")
    private File outputDirectory;
    @Parameter(property="maven.simplify.simplifiedPomFileName", defaultValue=".simplified-pom.xml")
    protected String simplifiedPomFileName;
    @Parameter(property="maven.simplify.fileComment")
    private String fileComment;
    @Parameter(property="maven.simplify.useTabIndent", defaultValue="false")
    private boolean useTabIndent;

    protected File getSimplifiedPomFile() {
        return new File(this.outputDirectory, this.simplifiedPomFileName);
    }

    protected void writePom(Model model, File pomFile) throws MojoExecutionException {
        String pomFileString;
        boolean success;
        File parentFile = pomFile.getParentFile();
        if (!parentFile.exists() && !(success = parentFile.mkdirs())) {
            throw new MojoExecutionException("Failed to create directory " + pomFile.getParent());
        }
        if (model.getModelEncoding() == null) {
            this.getLog().warn((CharSequence)("No encoding specified for " + pomFile + ", using " + StandardCharsets.UTF_8));
            model.setModelEncoding(StandardCharsets.UTF_8.name());
        }
        MavenXpp3Writer pomWriter = new MavenXpp3Writer(model, this.fileComment, this.useTabIndent);
        try (StringWriter stringWriter = new StringWriter(4096);){
            pomWriter.write(stringWriter);
            pomFileString = stringWriter.getBuffer().toString();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Internal I/O error!", (Exception)e);
        }
        pomFileString = pomFileString.replace("\r", "");
        pomFileString = pomFileString.replaceAll("\n{2,}", "\n");
        pomFileString = pomFileString.replace(" />", "/>");
        this.writeStringToFile(pomFileString, pomFile, model.getModelEncoding());
    }

    private void writeStringToFile(String data, File file, String encoding) throws MojoExecutionException {
        Throwable throwable;
        byte[] binaryData;
        block35: {
            try {
                binaryData = data.getBytes(encoding);
                if (file.isFile() && file.canRead() && file.length() == (long)binaryData.length) {
                    try {
                        throwable = null;
                        try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                            byte[] buffer = new byte[binaryData.length];
                            inputStream.read(buffer);
                            if (Arrays.equals(buffer, binaryData)) {
                                this.getLog().debug((CharSequence)"Arrays.equals( buffer, binaryData ) ");
                                return;
                            }
                            this.getLog().debug((CharSequence)"Not Arrays.equals( buffer, binaryData ) ");
                            break block35;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (IOException e) {
                        this.getLog().debug((CharSequence)("Issue reading file: " + file.getPath()), (Throwable)e);
                    }
                    break block35;
                }
                this.getLog().debug((CharSequence)("file: " + file + ",file.length(): " + file.length() + ", binaryData.length: " + binaryData.length));
            }
            catch (IOException e) {
                throw new MojoExecutionException("cannot read String as bytes", (Exception)e);
            }
        }
        try {
            throwable = null;
            try (OutputStream outStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                outStream.write(binaryData);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write to " + file, (Exception)e);
        }
    }
}

