/*
 * Decompiled with CFR 0.152.
 */
package icu.mhb.mybatisplus.plugln.core;

import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.query.Query;
import com.baomidou.mybatisplus.core.conditions.segments.GroupBySegmentList;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import icu.mhb.mybatisplus.plugln.core.JoinWrapper;
import icu.mhb.mybatisplus.plugln.core.support.SupportJoinLambdaWrapper;
import icu.mhb.mybatisplus.plugln.entity.HavingBuild;
import icu.mhb.mybatisplus.plugln.entity.OrderByBuild;
import icu.mhb.mybatisplus.plugln.tookit.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

public class JoinLambdaWrapper<T>
extends SupportJoinLambdaWrapper<T, JoinLambdaWrapper<T>>
implements Query<JoinLambdaWrapper<T>, T, SFunction<T, ?>> {
    private List<SharedString> joinSqlSelect = new ArrayList<SharedString>();
    private List<SharedString> joinSql = new ArrayList<SharedString>();
    private List<String> joinConditionSql = new ArrayList<String>();
    private boolean sqlCacheFlag;
    private SharedString sqlCache = new SharedString();
    private boolean sqlSelectFlag;
    private SharedString sqlSelectCahce = new SharedString();

    public JoinLambdaWrapper(T entity) {
        super.setEntity(entity);
        this.initNeed();
    }

    public JoinLambdaWrapper(Class<T> entityClass) {
        this.entityClass = entityClass;
        this.initNeed();
    }

    JoinLambdaWrapper(T entity, Class<T> entityClass, SharedString sqlSelect, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments, SharedString lastSql, SharedString sqlComment, SharedString sqlFirst) {
        super.setEntity(entity);
        this.entityClass = entityClass;
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
        this.sqlSelect = sqlSelect;
        this.lastSql = lastSql;
        this.sqlComment = sqlComment;
    }

    @SafeVarargs
    public final JoinLambdaWrapper<T> select(SFunction<T, ?> ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            this.sqlSelect.setStringValue(this.columnsToString(false, columns));
        }
        return (JoinLambdaWrapper)this.typedThis;
    }

    public JoinLambdaWrapper<T> select(Predicate<TableFieldInfo> predicate) {
        return this.select(this.entityClass, predicate);
    }

    public JoinLambdaWrapper<T> select(Class<T> entityClass, Predicate<TableFieldInfo> predicate) {
        this.entityClass = entityClass;
        this.sqlSelect.setStringValue(TableInfoHelper.getTableInfo(this.getEntityOrMasterClass()).chooseSelect(predicate));
        return (JoinLambdaWrapper)this.typedThis;
    }

    public String getSqlSelect() {
        if (this.sqlSelectFlag) {
            return this.sqlSelectCahce.getStringValue();
        }
        if (StringUtil.isBlank(this.sqlSelect.getStringValue())) {
            this.selectAll();
        }
        StringBuilder stringValue = new StringBuilder(this.sqlSelect.getStringValue());
        for (SharedString sharedString : this.joinSqlSelect) {
            if (StringUtil.isBlank(sharedString.getStringValue())) continue;
            if (stringValue.length() != 0) {
                stringValue.append(",");
            }
            stringValue.append(sharedString.getStringValue());
        }
        String selectSql = stringValue.toString();
        this.sqlSelectFlag = true;
        this.sqlSelectCahce.setStringValue(selectSql);
        return selectSql;
    }

    protected JoinLambdaWrapper<T> instance() {
        return new JoinLambdaWrapper<Object>(this.getEntity(), this.entityClass, null, this.paramNameSeq, this.paramNameValuePairs, new MergeSegments(), SharedString.emptyString(), SharedString.emptyString(), SharedString.emptyString());
    }

    public String getSqlSegment() {
        if (this.sqlCacheFlag) {
            return this.sqlCache.getStringValue();
        }
        String sql = this.expression.getSqlSegment();
        StringBuilder sqlBuilder = new StringBuilder();
        boolean sqlIsBlank = StringUtil.isBlank(sql) || this.expression.getNormal().size() == 0;
        boolean conditionSqlIsNotEmpty = CollectionUtils.isNotEmpty(this.joinConditionSql);
        if (sqlIsBlank && conditionSqlIsNotEmpty) {
            sqlBuilder.append("WHERE");
        }
        if (conditionSqlIsNotEmpty) {
            for (int i = 0; i < this.joinConditionSql.size(); ++i) {
                String conditionSql = this.joinConditionSql.get(i);
                sqlBuilder.append(" ");
                if (i > 0) {
                    sqlBuilder.append("and");
                }
                sqlBuilder.append(conditionSql);
            }
        }
        if (!sqlIsBlank) {
            if (conditionSqlIsNotEmpty) {
                sqlBuilder.append(" ").append("and").append(" ");
            }
            sqlBuilder.append(sql);
        }
        sqlBuilder.append("\n").append(this.lastSql.getStringValue());
        String sqlBuilderStr = sqlBuilder.toString();
        this.sqlCache.setStringValue(sqlBuilderStr);
        this.sqlCacheFlag = true;
        return sqlBuilderStr;
    }

    public <J> JoinWrapper<J, T> join(Class<J> clz) {
        return new JoinWrapper(clz, this);
    }

    public <J, F> JoinWrapper<J, T> leftJoin(Class<J> clz, SFunction<J, Object> joinTableField, SFunction<F, Object> masterTableField) {
        return this.join(clz).leftJoin(joinTableField, masterTableField);
    }

    public <J, F> JoinWrapper<J, T> rightJoin(Class<J> clz, SFunction<J, Object> joinTableField, SFunction<F, Object> masterTableField) {
        return this.join(clz).rightJoin(joinTableField, masterTableField);
    }

    public <J, F> JoinWrapper<J, T> innerJoin(Class<J> clz, SFunction<J, Object> joinTableField, SFunction<F, Object> masterTableField) {
        return this.join(clz).innerJoin(joinTableField, masterTableField);
    }

    void setJoinConditionSql(String sql, String key, Map<String, Object> joinParamNameValuePairs) {
        if (StringUtil.isNotBlank(sql)) {
            this.paramNameValuePairs.put(key, joinParamNameValuePairs);
            sql = sql.replace("WHERE", " ");
            sql = sql.replaceAll("ew.paramNameValuePairs", "ew.paramNameValuePairs." + key);
            this.joinConditionSql.add(sql);
        }
    }

    void setJoinSql(List<SharedString> sql) {
        if (CollectionUtils.isNotEmpty(sql)) {
            this.joinSql.addAll(sql);
        }
    }

    void setOrderBy(List<OrderByBuild> orderByBuildList) {
        if (!orderByBuildList.isEmpty()) {
            for (OrderByBuild orderByBuild : orderByBuildList) {
                super.doIt(orderByBuild.isCondition(), orderByBuild.getSqlSegmentList().toArray(new ISqlSegment[0]));
            }
        }
    }

    void setGroupBy(GroupBySegmentList groupBy) {
        if (!groupBy.isEmpty()) {
            for (ISqlSegment sqlSegment : groupBy) {
                this.doIt(true, new ISqlSegment[]{SqlKeyword.GROUP_BY, sqlSegment});
            }
        }
    }

    void setHaving(List<HavingBuild> havingBuildList) {
        if (havingBuildList != null && !havingBuildList.isEmpty()) {
            for (HavingBuild havingBuild : havingBuildList) {
                this.having(havingBuild.isCondition(), havingBuild.getSql(), havingBuild.getParams());
            }
        }
    }

    void setJoinSelect(SharedString ... select) {
        this.joinSqlSelect.addAll(Arrays.asList(select));
    }

    void setLastSql(SharedString last) {
        if (StringUtil.isNotBlank(last.getStringValue())) {
            this.lastSql = last;
        }
    }

    public String getJoinSql() {
        StringBuilder sql = new StringBuilder();
        if (CollectionUtils.isNotEmpty(this.joinSql)) {
            for (SharedString sharedString : this.joinSql) {
                sql.append(sharedString.getStringValue()).append("\n");
            }
        }
        return sql.toString();
    }

    public String getCustomSqlSegment() {
        return super.getCustomSqlSegment();
    }

    @Override
    protected void initNeedSun() {
        super.initNeedSun();
    }
}

