/*
 * Decompiled with CFR 0.152.
 */
package icu.mhb.mybatisplus.plugln.core;

import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.query.Query;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.core.toolkit.support.SerializedLambda;
import icu.mhb.mybatisplus.plugln.core.JoinLambdaWrapper;
import icu.mhb.mybatisplus.plugln.core.support.SupportJoinLambdaWrapper;
import icu.mhb.mybatisplus.plugln.entity.HavingBuild;
import icu.mhb.mybatisplus.plugln.entity.OrderByBuild;
import icu.mhb.mybatisplus.plugln.enums.SqlExcerpt;
import icu.mhb.mybatisplus.plugln.tookit.IdUtil;
import icu.mhb.mybatisplus.plugln.tookit.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

public class JoinWrapper<T, J>
extends SupportJoinLambdaWrapper<T, JoinWrapper<T, J>>
implements Query<JoinWrapper<T, J>, T, SFunction<T, ?>> {
    private JoinLambdaWrapper<J> wrapper;
    private List<SharedString> sqlJoin = new ArrayList<SharedString>();
    private List<HavingBuild> havingBuildList = null;
    private List<OrderByBuild> orderByBuildList = new ArrayList<OrderByBuild>();

    public JoinWrapper(JoinLambdaWrapper<J> wrapper) {
        this(null, wrapper);
    }

    JoinWrapper(T entity, JoinLambdaWrapper<J> wrapper) {
        super.setEntity(entity);
        super.initNeed();
        this.wrapper = wrapper;
    }

    JoinWrapper(Class<T> entityClass, JoinLambdaWrapper<J> wrapper) {
        this.entityClass = entityClass;
        this.wrapper = wrapper;
    }

    JoinWrapper(T entity, Class<T> entityClass, SharedString sqlSelect, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments, SharedString lastSql, SharedString sqlComment, SharedString sqlFirst) {
        super.setEntity(entity);
        this.entityClass = entityClass;
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
        this.sqlSelect = sqlSelect;
        this.lastSql = lastSql;
        this.sqlComment = sqlComment;
    }

    @SafeVarargs
    public final JoinWrapper<T, J> select(SFunction<T, ?> ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            this.sqlSelect.setStringValue(this.columnsToString(false, columns));
        }
        return (JoinWrapper)this.typedThis;
    }

    public JoinWrapper<T, J> select(Predicate<TableFieldInfo> predicate) {
        return this.select(this.entityClass, predicate);
    }

    public JoinWrapper<T, J> select(Class<T> entityClass, Predicate<TableFieldInfo> predicate) {
        this.entityClass = entityClass;
        this.sqlSelect.setStringValue(TableInfoHelper.getTableInfo(this.getEntityOrMasterClass()).chooseSelect(predicate));
        return (JoinWrapper)this.typedThis;
    }

    public String getSqlSelect() {
        return this.sqlSelect.getStringValue();
    }

    protected JoinWrapper<T, J> instance() {
        return new JoinWrapper<Object, J>(this.getEntity(), this.entityClass, null, this.paramNameSeq, this.paramNameValuePairs, new MergeSegments(), SharedString.emptyString(), SharedString.emptyString(), SharedString.emptyString());
    }

    public <F> JoinWrapper<T, J> leftJoin(SFunction<T, Object> joinTableField, SFunction<F, Object> masterTableField) {
        this.buildJoinSql(joinTableField, masterTableField, SqlExcerpt.LEFT_JOIN);
        return (JoinWrapper)this.typedThis;
    }

    public <F> JoinWrapper<T, J> rightJoin(SFunction<T, Object> joinTableField, SFunction<F, Object> masterTableField) {
        this.buildJoinSql(joinTableField, masterTableField, SqlExcerpt.RIGHT_JOIN);
        return (JoinWrapper)this.typedThis;
    }

    public <F> JoinWrapper<T, J> innerJoin(SFunction<T, Object> joinTableField, SFunction<F, Object> masterTableField) {
        this.buildJoinSql(joinTableField, masterTableField, SqlExcerpt.INNER_JOIN);
        return (JoinWrapper)this.typedThis;
    }

    public JoinWrapper<T, J> having(boolean condition, String sqlHaving, Object ... params) {
        if (this.havingBuildList == null) {
            this.havingBuildList = new ArrayList<HavingBuild>();
        }
        HavingBuild havingBuild = HavingBuild.builder().condition(condition).sql(sqlHaving).params(params).build();
        this.havingBuildList.add(havingBuild);
        return (JoinWrapper)this.typedThis;
    }

    public JoinWrapper<T, J> joinAnd(SFunction<T, Object> field, Object val, int index) {
        String column = this.columnToString(field);
        SharedString sql = this.sqlJoin.get(index);
        if (sql == null || StringUtil.isBlank(sql.getStringValue())) {
            throw ExceptionUtils.mpe((String)"no such subscript join", (Object[])new Object[0]);
        }
        sql.setStringValue(sql.getStringValue() + String.format(SqlExcerpt.AND.getSql(), column, val));
        this.sqlJoin.remove(index);
        this.sqlJoin.add(index, sql);
        return (JoinWrapper)this.typedThis;
    }

    protected JoinWrapper<T, J> doIt(boolean condition, ISqlSegment ... sqlSegments) {
        boolean flag = false;
        for (ISqlSegment sqlSegment : sqlSegments) {
            SqlKeyword sqlKeyword;
            if (!(sqlSegment instanceof SqlKeyword) || !(sqlKeyword = (SqlKeyword)sqlSegment).getSqlSegment().equals(SqlKeyword.ORDER_BY.getSqlSegment())) continue;
            flag = true;
        }
        if (flag) {
            OrderByBuild orderByBuild = OrderByBuild.builder().sqlSegmentList(Arrays.asList(sqlSegments)).condition(condition).build();
            this.orderByBuildList.add(orderByBuild);
            return (JoinWrapper)this.typedThis;
        }
        return (JoinWrapper)super.doIt(condition, sqlSegments);
    }

    private <F> void buildJoinSql(SFunction<T, Object> joinTableField, SFunction<F, Object> masterTableField, SqlExcerpt sqlExcerpt) {
        SerializedLambda joinTableResolve = LambdaUtils.resolve(joinTableField);
        SerializedLambda masterTableResolve = LambdaUtils.resolve(masterTableField);
        Class joinTableClass = joinTableResolve.getImplClass();
        Class masterTableClass = masterTableResolve.getImplClass();
        TableInfo joinTableInfo = TableInfoHelper.getTableInfo((Class)joinTableClass);
        Assert.notNull((Object)joinTableInfo, (String)"can not find tableInfo cache for this entity [%s]", (Object[])new Object[]{joinTableClass.getName()});
        String joinTableAlias = this.getAlias(joinTableClass);
        String masterTableAlias = this.getAlias(masterTableClass);
        String joinColumn = this.getColumn(joinTableResolve, true);
        String masterColumn = this.getColumn(masterTableResolve, true);
        SharedString sharedString = SharedString.emptyString();
        sharedString.setStringValue(String.format(sqlExcerpt.getSql(), joinTableInfo.getTableName(), joinTableAlias, joinTableAlias, joinColumn, masterTableAlias, masterColumn));
        this.sqlJoin.add(sharedString);
    }

    public JoinLambdaWrapper<J> end() {
        this.wrapper.setJoinSelect(this.sqlSelect);
        this.wrapper.setJoinSql(this.sqlJoin);
        this.wrapper.setOrderBy(this.orderByBuildList);
        this.wrapper.setGroupBy(this.expression.getGroupBy());
        this.wrapper.setHaving(this.havingBuildList);
        this.wrapper.setLastSql(this.lastSql);
        this.lastSql = SharedString.emptyString();
        this.expression.getOrderBy().clear();
        this.expression.getHaving().clear();
        this.expression.getGroupBy().clear();
        this.wrapper.setJoinConditionSql(this.getCustomSqlSegment(), IdUtil.getSimpleUUID(), this.paramNameValuePairs);
        return this.wrapper;
    }
}

