/*
 * Decompiled with CFR 0.152.
 */
package icu.mhb.mybatisplus.plugln.config;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import icu.mhb.mybatisplus.plugln.enums.SqlExcerpt;

public class MybatisPlusJoinConfig {
    private String columnAliasKeyword;
    private String tableAliasKeyword;
    private boolean isUseMsCache = true;

    private MybatisPlusJoinConfig() {
    }

    private MybatisPlusJoinConfig(String columnAliasKeyword, String tableAliasKeyword, boolean isUseMsCache) {
        this.columnAliasKeyword = columnAliasKeyword;
        this.tableAliasKeyword = tableAliasKeyword;
        this.isUseMsCache = isUseMsCache;
    }

    public static MybatisPlusJoinConfigBuilder builder() {
        return new MybatisPlusJoinConfigBuilder();
    }

    public String getColumnAliasKeyword() {
        return this.columnAliasKeyword;
    }

    public String getTableAliasKeyword() {
        return this.tableAliasKeyword;
    }

    public boolean isUseMsCache() {
        return this.isUseMsCache;
    }

    public static class MybatisPlusJoinConfigBuilder {
        private String columnAliasKeyword;
        private String tableAliasKeyword;
        private boolean isUseMsCache = true;

        public MybatisPlusJoinConfigBuilder columnAliasKeyword(String columnAliasKeyword) {
            this.columnAliasKeyword = columnAliasKeyword;
            return this;
        }

        public MybatisPlusJoinConfigBuilder isUseMsCache(boolean isUseMsCache) {
            this.isUseMsCache = isUseMsCache;
            return this;
        }

        public MybatisPlusJoinConfigBuilder tableAliasKeyword(String tableAliasKeyword) {
            this.tableAliasKeyword = tableAliasKeyword;
            return this;
        }

        public MybatisPlusJoinConfig build() {
            if (StringUtils.isNotBlank((CharSequence)this.columnAliasKeyword)) {
                SqlExcerpt.COLUMNS_AS.updateValue(" %s " + this.columnAliasKeyword + " %s ", "");
            }
            if (StringUtils.isNotBlank((CharSequence)this.tableAliasKeyword)) {
                SqlExcerpt.TABLE_AS.updateValue(" %s " + this.columnAliasKeyword + " %s ", "");
                SqlExcerpt.LEFT_JOIN.updateValue(" LEFT JOIN %s " + this.tableAliasKeyword + " %s ON %s.%s = %s.%s", "");
                SqlExcerpt.RIGHT_JOIN.updateValue(" RIGHT JOIN %s " + this.tableAliasKeyword + " %s ON %s.%s = %s.%s", "");
                SqlExcerpt.INNER_JOIN.updateValue(" INNER JOIN %s " + this.tableAliasKeyword + " %s ON %s.%s = %s.%s", "");
            }
            return new MybatisPlusJoinConfig(this.columnAliasKeyword, this.tableAliasKeyword, this.isUseMsCache);
        }
    }
}

