/*
 * Decompiled with CFR 0.152.
 */
package id.gits.baso;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import id.gits.baso.R;

public class BasoProgressView
extends RelativeLayout {
    public static final int DEF_FINISHED_IMAGE_WIDTH = 120;
    public static final int DEF_FINISHED_TEXT_SIZE = 18;
    private ViewGroup mStoppedLayout;
    private TextView mStoppedTextView;
    private ImageView mStoppedImageView;
    private Button mStoppedButton;
    private ViewGroup mProgressingLayout;
    private ProgressBar mProgressingBar;
    private TextView mProgressingTextView;
    private String mFinishedButtonText;
    private Drawable mFinishedButtonBackground;
    private String mFinishedText;
    private float mFinishedTextSize;
    private Drawable mFinishedImageDrawable;
    private int mFinishedImageWidth;
    private int mFinishedImageHeight;
    private String mProgressText;
    private BasoStatus mBasoStatus = BasoStatus.PROGRESSING;

    public BasoProgressView(Context context) {
        this(context, null);
    }

    public BasoProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (this.isInEditMode()) {
            this.mBasoStatus = BasoStatus.ERROR;
        }
        this.injectViews();
        this.applyAttrs(context, attrs);
    }

    private void injectViews() {
        BasoProgressView.inflate((Context)this.getContext(), (int)R.layout.view_baso, (ViewGroup)this);
        this.mProgressingLayout = (ViewGroup)this.findViewById(R.id.baso_ProgressingLayout);
        this.mProgressingTextView = (TextView)this.findViewById(R.id.baso_ProgressingText);
        this.mStoppedLayout = (ViewGroup)this.findViewById(R.id.baso_StoppedLayout);
        this.mStoppedTextView = (TextView)this.findViewById(R.id.baso_StoppedText);
        this.mStoppedImageView = (ImageView)this.findViewById(R.id.baso_StoppedImage);
        this.mStoppedButton = (Button)this.findViewById(R.id.baso_StoppedButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.BasoProgressView, 0, 0);
        try {
            this.mFinishedButtonText = a.getString(R.styleable.BasoProgressView_baso_finishButtonText);
            this.mFinishedButtonBackground = a.getDrawable(R.styleable.BasoProgressView_baso_finishButtonBackground);
            this.mFinishedText = a.getString(R.styleable.BasoProgressView_baso_finishText);
            float px = TypedValue.applyDimension((int)2, (float)18.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
            this.mFinishedTextSize = a.getDimension(R.styleable.BasoProgressView_baso_finishTextSize, px);
            this.mFinishedImageDrawable = a.getDrawable(R.styleable.BasoProgressView_baso_finishSrc);
            px = TypedValue.applyDimension((int)1, (float)120.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
            this.mFinishedImageWidth = (int)a.getDimension(R.styleable.BasoProgressView_baso_finishSrcWidth, px);
            this.mFinishedImageHeight = (int)a.getDimension(R.styleable.BasoProgressView_baso_finishSrcHeight, 0.0f);
            this.mProgressText = a.getString(R.styleable.BasoProgressView_baso_progressText);
        }
        finally {
            a.recycle();
        }
        this.initLayout();
    }

    private void initLayout() {
        this.mStoppedButton.setVisibility(TextUtils.isEmpty((CharSequence)this.mProgressText) ? 8 : 0);
        this.mProgressingTextView.setText((CharSequence)this.mProgressText);
        this.setFinishedButtonText(this.mFinishedButtonText);
        this.setFinishedButtonBackground(this.mFinishedButtonBackground);
        this.setFinishedImageDrawable(this.mFinishedImageDrawable);
        this.setFinishedImageLayoutParam(this.mFinishedImageWidth, this.mFinishedImageHeight);
        this.setFinishedText(this.mFinishedText);
        this.setFinishedTextSize(this.mFinishedTextSize);
        this.toggleLayout();
    }

    private void toggleLayout() {
        if (this.mBasoStatus == BasoStatus.PROGRESSING) {
            this.mStoppedLayout.setVisibility(8);
            this.mProgressingLayout.setVisibility(0);
            this.setVisibility(0);
        } else if (this.mBasoStatus == BasoStatus.ERROR) {
            this.mStoppedLayout.setVisibility(0);
            this.mProgressingLayout.setVisibility(8);
            this.setVisibility(0);
        } else {
            this.mStoppedLayout.setVisibility(8);
            this.mProgressingLayout.setVisibility(8);
            this.setVisibility(8);
        }
    }

    public void setOnButtonClickListener(View.OnClickListener onClickListener) {
        this.mStoppedButton.setOnClickListener(onClickListener);
    }

    public void startProgress() {
        this.mBasoStatus = BasoStatus.PROGRESSING;
        this.toggleLayout();
    }

    public void stopAndGone() {
        this.mBasoStatus = BasoStatus.GONE;
        this.toggleLayout();
    }

    public void stop() {
        this.mBasoStatus = BasoStatus.ERROR;
        this.toggleLayout();
    }

    public void stopAndError(String errorMessage) {
        this.mBasoStatus = BasoStatus.ERROR;
        this.setFinishedText(errorMessage);
        this.toggleLayout();
    }

    public String getFinishedButtonText() {
        return this.mFinishedButtonText;
    }

    public void setFinishedButtonText(String finishedButtonText) {
        this.mFinishedButtonText = finishedButtonText;
        this.mStoppedButton.setVisibility(TextUtils.isEmpty((CharSequence)this.mFinishedButtonText) ? 8 : 0);
        this.mStoppedButton.setText((CharSequence)this.mFinishedButtonText);
    }

    public Drawable getFinishedButtonBackground() {
        return this.mFinishedButtonBackground;
    }

    public void setFinishedButtonBackground(Drawable finishedButtonBackground) {
        this.mFinishedButtonBackground = finishedButtonBackground;
        if (finishedButtonBackground != null) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.mStoppedButton.setBackground(this.mFinishedButtonBackground);
            } else {
                this.mStoppedButton.setBackgroundDrawable(this.mFinishedButtonBackground);
            }
        }
    }

    public String getFinishedText() {
        return this.mFinishedText;
    }

    public void setFinishedText(String finishedText) {
        this.mFinishedText = finishedText;
        this.mStoppedTextView.setVisibility(TextUtils.isEmpty((CharSequence)this.mFinishedText) ? 8 : 0);
        this.mStoppedTextView.setText((CharSequence)this.mFinishedText);
    }

    public float getFinishedTextSize() {
        return this.mFinishedTextSize;
    }

    public void setFinishedTextSize(float finishedTextSize) {
        this.mFinishedTextSize = finishedTextSize;
        this.mStoppedTextView.setTextSize(0, this.mFinishedTextSize);
    }

    public Drawable getFinishedImageDrawable() {
        return this.mFinishedImageDrawable;
    }

    public void setFinishedImageDrawable(Drawable finishedImageDrawable) {
        this.mFinishedImageDrawable = finishedImageDrawable;
        this.mStoppedImageView.setVisibility(this.mFinishedImageDrawable == null ? 8 : 0);
        if (this.mFinishedImageDrawable != null) {
            this.mStoppedImageView.setImageDrawable(this.mFinishedImageDrawable);
        }
    }

    public void setFinishedImageResource(@DrawableRes int resource) {
        Drawable drawable = ContextCompat.getDrawable((Context)this.getContext(), (int)resource);
        this.setFinishedImageDrawable(drawable);
    }

    public float getFinishedImageWidth() {
        return this.mFinishedImageWidth;
    }

    public float getFinishedImageHeight() {
        return this.mFinishedImageHeight;
    }

    public void setFinishedImageLayoutParam(int width, int height) {
        this.mFinishedImageWidth = width;
        this.mFinishedImageHeight = height;
        int sWidth = this.mFinishedImageWidth;
        if (this.mFinishedImageWidth <= 0) {
            sWidth = -2;
        }
        int sHeight = this.mFinishedImageHeight;
        if (this.mFinishedImageHeight <= 0) {
            sHeight = -2;
        }
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(sWidth, sHeight);
        params.bottomMargin = (int)(this.getResources().getDisplayMetrics().density * 24.0f);
        this.mStoppedImageView.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private static enum BasoStatus {
        PROGRESSING,
        ERROR,
        GONE;

    }
}

