/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.intellij;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import ie.corballis.fixtures.intellij.JsonFixturesLineMarkersPass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonFixturesHighlightingPassFactory
implements TextEditorHighlightingPassFactory {
    private final TextEditorHighlightingPassRegistrar passRegistrar;

    public JsonFixturesHighlightingPassFactory(TextEditorHighlightingPassRegistrar passRegistrar) {
        this.passRegistrar = passRegistrar;
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile psiFile, @NotNull Editor editor) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)psiFile);
        if (module == null) {
            return null;
        }
        return new JsonFixturesLineMarkersPass(module.getProject(), editor.getDocument(), editor.getMarkupModel());
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void initComponent() {
        this.passRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, TextEditorHighlightingPassRegistrar.Anchor.LAST, 4, true, true);
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        return "ie.corballis.fixtures.intellij.JsonFixturesHighlightingPassFactory";
    }
}

