/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.annotation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import ie.corballis.fixtures.annotation.FieldAnnotationProcessor;
import ie.corballis.fixtures.annotation.Fixture;
import ie.corballis.fixtures.annotation.FixtureFieldAnnotationProcessor;
import ie.corballis.fixtures.core.BeanFactory;
import ie.corballis.fixtures.core.InvocationContextHolder;
import ie.corballis.fixtures.settings.Settings;
import ie.corballis.fixtures.settings.SettingsHolder;
import ie.corballis.fixtures.util.FieldSetter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;

public class FixtureAnnotations {
    private static final Map<Class<? extends Annotation>, FieldAnnotationProcessor<?>> annotationProcessorMap = Maps.newHashMap();

    public static void initFixtures(Object targetInstance) throws Exception {
        FixtureAnnotations.initFixtures(targetInstance, null);
    }

    public static void initFixtures(Object targetInstance, Settings.Builder settings) throws Exception {
        Preconditions.checkNotNull((Object)targetInstance, (Object)"Target instance must not be null");
        SettingsHolder.updateSettings(settings == null ? Settings.defaultSettings() : settings.build());
        InvocationContextHolder.initTestExecutorThread(Thread.currentThread());
        SettingsHolder.settings().getSnapshotGenerator().validateSnapshots();
        FixtureAnnotations.processAnnotations(targetInstance, SettingsHolder.settings().getBeanFactory());
    }

    private static void processAnnotations(Object targetInstance, BeanFactory beanFactory) throws Exception {
        for (Class<?> clazz = targetInstance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                for (Annotation annotation : field.getAnnotations()) {
                    Object bean = FixtureAnnotations.generateFixture(annotation, field, beanFactory);
                    if (bean == null) continue;
                    try {
                        new FieldSetter(targetInstance, field).set(bean);
                    }
                    catch (Exception e) {
                        throw new Exception("Problems setting field " + field.getName() + " annotated with " + annotation, e);
                    }
                }
            }
        }
    }

    private static Object generateFixture(Annotation annotation, Field field, BeanFactory beanFactory) throws IllegalAccessException, InstantiationException, IOException {
        Object result = null;
        if (annotationProcessorMap.containsKey(annotation.annotationType())) {
            FieldAnnotationProcessor<?> processor = annotationProcessorMap.get(annotation.annotationType());
            result = processor.process(annotation, field, beanFactory);
        }
        return result;
    }

    static {
        annotationProcessorMap.put(Fixture.class, new FixtureFieldAnnotationProcessor());
    }
}

