/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.assertion;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import ie.corballis.fixtures.assertion.MatchingMode;
import ie.corballis.fixtures.assertion.PropertyMatcherAssertingVisitor;
import ie.corballis.fixtures.assertion.PropertyMatcherFilteringVisitor;
import ie.corballis.fixtures.assertion.PropertyMatchers;
import ie.corballis.fixtures.settings.SettingsHolder;
import ie.corballis.fixtures.util.JsonUtils;
import ie.corballis.fixtures.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.hamcrest.MatcherAssert;
import uk.co.datumedge.hamcrest.json.SameJSONAs;

public class FixtureAssert
extends AbstractAssert<FixtureAssert, Object> {
    public FixtureAssert(Object actual) {
        super(actual, FixtureAssert.class);
    }

    public static FixtureAssert assertThat(Object actual) {
        return new FixtureAssert(actual);
    }

    public FixtureAssert matches(String ... fixtures) throws JsonProcessingException {
        return this.matches(PropertyMatchers.empty(), fixtures);
    }

    public FixtureAssert matches(PropertyMatchers matchers, String ... fixtures) throws JsonProcessingException {
        this.assertJSON(MatchingMode.MATCHES, matchers, fixtures);
        return this;
    }

    private void assertJSON(MatchingMode matchingMode, PropertyMatchers matchers, String ... fixtures) throws JsonProcessingException {
        this.isNotNull();
        SameJSONAs<String> expected = matchingMode.getJsonMatcher(SettingsHolder.settings().getBeanFactory().createAsString(fixtures));
        if (matchers.isEmpty()) {
            this.assertThatExpectedMatchesWithActual(expected, this.actual, SettingsHolder.settings().getObjectMapper().writeValueAsString(this.actual), fixtures);
        } else {
            this.compareWithoutOverriddenProperties(matchingMode, matchers, fixtures);
            this.verifyOverriddenPropertiesOnly(matchers);
        }
    }

    private void assertThatExpectedMatchesWithActual(SameJSONAs<String> expected, Object actual, String actualJson, String[] fixtures) throws JsonProcessingException {
        try {
            MatcherAssert.assertThat((Object)actualJson, expected);
        }
        catch (AssertionError assertionError) {
            this.failAndPrettyPrintError(assertionError, actual, fixtures);
        }
    }

    private void failAndPrettyPrintError(AssertionError assertionError, Object actual, String[] fixtures) throws JsonProcessingException {
        String actualPrettyString = StringUtils.unifyLineEndings(SettingsHolder.settings().getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(actual));
        String expectedPrettyString = StringUtils.unifyLineEndings(SettingsHolder.settings().getBeanFactory().createAsString(true, fixtures));
        System.err.print(((Throwable)((Object)assertionError)).getMessage());
        Assertions.assertThat((String)actualPrettyString).isEqualTo((Object)expectedPrettyString);
    }

    private void compareWithoutOverriddenProperties(MatchingMode matchingMode, PropertyMatchers matchers, String[] fixtures) throws JsonProcessingException {
        Object clearedActual = this.removeOverriddenProperties(this.actual, matchers, this::failWhenNoMatchingPropertyFound);
        Object clearedExpected = this.removeOverriddenProperties(SettingsHolder.settings().getBeanFactory().create(this.getTypeToConvert(this.actual), fixtures), matchers);
        String clearedActualString = SettingsHolder.settings().getObjectMapper().writeValueAsString(clearedActual);
        SameJSONAs<String> expectedMatcher = matchingMode.getJsonMatcher(SettingsHolder.settings().getObjectMapper().writeValueAsString(clearedExpected));
        this.assertThatExpectedMatchesWithActual(expectedMatcher, clearedActual, clearedActualString, fixtures);
    }

    private Object removeOverriddenProperties(Object entity, PropertyMatchers matchers) {
        Consumer<List<String>> noopHandler = nonMatchingProperties -> {};
        return this.removeOverriddenProperties(entity, matchers, noopHandler);
    }

    private Object removeOverriddenProperties(Object entity, PropertyMatchers matchers, Consumer<List<String>> nonMatchingPropertyHandler) {
        Set<String> properties = matchers.getProperties();
        ArrayList nonMatchingProperties = Lists.newArrayList();
        if (!matchers.isEmpty()) {
            Object newObject = SettingsHolder.settings().getObjectMapper().convertValue(entity, this.getTypeToConvert(entity));
            for (String property : properties) {
                ArrayList parts = Lists.newArrayList((Object[])property.split("\\."));
                JsonNode updatedNode = (JsonNode)SettingsHolder.settings().getObjectMapper().convertValue(newObject, JsonNode.class);
                PropertyMatcherFilteringVisitor filteringVisitor = new PropertyMatcherFilteringVisitor(parts);
                newObject = JsonUtils.visitElements(updatedNode, newObject, new Stack<Object>(), filteringVisitor);
                if (filteringVisitor.isMatched()) continue;
                nonMatchingProperties.add(property);
            }
            if (!nonMatchingProperties.isEmpty()) {
                nonMatchingPropertyHandler.accept(nonMatchingProperties);
            }
            return newObject;
        }
        return entity;
    }

    private Class<?> getTypeToConvert(Object entity) {
        return entity.getClass().isArray() || entity instanceof Collection ? List.class : Map.class;
    }

    private void failWhenNoMatchingPropertyFound(List<String> nonMatchingProperties) {
        Collections.sort(nonMatchingProperties);
        String failure = String.format("The following properties %s could not be found in %s. Please check that you provided the correct path to the property you want to match with.", nonMatchingProperties, this.actual.getClass().getSimpleName());
        throw new IllegalArgumentException(failure);
    }

    private void verifyOverriddenPropertiesOnly(PropertyMatchers matchers) {
        for (String property : matchers.getProperties()) {
            ArrayList parts = Lists.newArrayList((Object[])property.split("\\."));
            JsonNode actual = (JsonNode)SettingsHolder.settings().getObjectMapper().convertValue(this.actual, JsonNode.class);
            JsonUtils.visitElements(actual, new PropertyMatcherAssertingVisitor(parts, matchers));
        }
    }

    public FixtureAssert matchesWithStrictOrder(String ... fixtures) throws JsonProcessingException {
        return this.matchesWithStrictOrder(PropertyMatchers.empty(), fixtures);
    }

    public FixtureAssert matchesWithStrictOrder(PropertyMatchers matchers, String ... fixtures) throws JsonProcessingException {
        this.assertJSON(MatchingMode.MATCHES_WITH_STRICT_ORDER, matchers, fixtures);
        return this;
    }

    public FixtureAssert matchesExactly(String ... fixtures) throws JsonProcessingException {
        return this.matchesExactly(PropertyMatchers.empty(), fixtures);
    }

    public FixtureAssert matchesExactly(PropertyMatchers matchers, String ... fixtures) throws JsonProcessingException {
        this.assertJSON(MatchingMode.MATCHES_EXACTLY, matchers, fixtures);
        return this;
    }

    public FixtureAssert matchesExactlyWithStrictOrder(String ... fixtures) throws JsonProcessingException {
        return this.matchesExactlyWithStrictOrder(PropertyMatchers.empty(), fixtures);
    }

    public FixtureAssert matchesExactlyWithStrictOrder(PropertyMatchers propertyMatchers, String ... fixtures) throws JsonProcessingException {
        this.assertJSON(MatchingMode.MATCHES_EXACTLY_WITH_STRICT_ORDER, propertyMatchers, fixtures);
        return this;
    }

    public FixtureAssert toMatchSnapshot() throws IOException {
        return this.toMatchSnapshot(false);
    }

    public FixtureAssert toMatchSnapshot(boolean regenerateFixture) throws IOException {
        return this.toMatchSnapshot(regenerateFixture, PropertyMatchers.empty());
    }

    public FixtureAssert toMatchSnapshot(boolean regenerateFixture, PropertyMatchers propertyMatchers) throws IOException {
        return this.toMatchSnapshot(MatchingMode.MATCHES, regenerateFixture, propertyMatchers);
    }

    private FixtureAssert toMatchSnapshot(MatchingMode matchingMode, boolean regenerateFixture, PropertyMatchers propertyMatchers) throws IOException {
        if (!SettingsHolder.settings().getSnapshotGenerator().createOrUpdateFixture(this.removeOverriddenProperties(this.actual, propertyMatchers), regenerateFixture)) {
            this.assertJSON(matchingMode, propertyMatchers, SettingsHolder.settings().getSnapshotGenerator().getCurrentSnapshotFixtureName());
        }
        return this;
    }

    public FixtureAssert toMatchSnapshot(PropertyMatchers propertyMatchers) throws IOException {
        return this.toMatchSnapshot(false, propertyMatchers);
    }

    public FixtureAssert toMatchSnapshotWithStrictOrder() throws IOException {
        return this.toMatchSnapshotWithStrictOrder(false, PropertyMatchers.empty());
    }

    public FixtureAssert toMatchSnapshotWithStrictOrder(boolean regenerateFixture, PropertyMatchers propertyMatchers) throws IOException {
        return this.toMatchSnapshot(MatchingMode.MATCHES_WITH_STRICT_ORDER, regenerateFixture, propertyMatchers);
    }

    public FixtureAssert toMatchSnapshotWithStrictOrder(PropertyMatchers propertyMatchers) throws IOException {
        return this.toMatchSnapshotWithStrictOrder(false, propertyMatchers);
    }

    public FixtureAssert toMatchSnapshotWithStrictOrder(boolean regenerateFixture) throws IOException {
        return this.toMatchSnapshotWithStrictOrder(false, PropertyMatchers.empty());
    }

    public FixtureAssert toMatchSnapshotExactly() throws IOException {
        return this.toMatchSnapshotExactly(false);
    }

    public FixtureAssert toMatchSnapshotExactly(boolean regenerateFixture) throws IOException {
        return this.toMatchSnapshotExactly(regenerateFixture, PropertyMatchers.empty());
    }

    public FixtureAssert toMatchSnapshotExactly(boolean regenerateFixture, PropertyMatchers propertyMatchers) throws IOException {
        return this.toMatchSnapshot(MatchingMode.MATCHES_EXACTLY, regenerateFixture, propertyMatchers);
    }

    public FixtureAssert toMatchSnapshotExactly(PropertyMatchers propertyMatchers) throws IOException {
        return this.toMatchSnapshotExactly(false, propertyMatchers);
    }

    public FixtureAssert toMatchSnapshotExactlyWithStrictOrder() throws IOException {
        return this.toMatchSnapshotExactlyWithStrictOrder(false);
    }

    public FixtureAssert toMatchSnapshotExactlyWithStrictOrder(boolean regenerateFixture) throws IOException {
        return this.toMatchSnapshotExactlyWithStrictOrder(regenerateFixture, PropertyMatchers.empty());
    }

    public FixtureAssert toMatchSnapshotExactlyWithStrictOrder(boolean regenerateFixture, PropertyMatchers propertyMatchers) throws IOException {
        return this.toMatchSnapshot(MatchingMode.MATCHES_EXACTLY_WITH_STRICT_ORDER, regenerateFixture, propertyMatchers);
    }

    public FixtureAssert toMatchSnapshotExactlyWithStrictOrder(PropertyMatchers propertyMatchers) throws IOException {
        return this.toMatchSnapshotExactlyWithStrictOrder(false, propertyMatchers);
    }
}

