/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.assertion.matcher;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class ZonedDateTimeEqualsInUtcMatcher
extends BaseMatcher<ZonedDateTime> {
    private final LocalDateTime expected;

    public ZonedDateTimeEqualsInUtcMatcher(ZonedDateTime expected) {
        this.expected = this.toUtcLocal(expected);
    }

    private LocalDateTime toUtcLocal(ZonedDateTime item) {
        return item == null ? null : LocalDateTime.ofInstant(item.toInstant(), ZoneOffset.UTC).truncatedTo(ChronoUnit.MILLIS);
    }

    public boolean matches(Object item) {
        ZonedDateTime actualWithZone = item == null ? null : ZonedDateTime.parse(String.valueOf(item));
        LocalDateTime actual = this.toUtcLocal(actualWithZone);
        return Objects.equals(actual, this.expected);
    }

    public void describeTo(Description description) {
        description.appendValue((Object)this.expected);
    }

    public static Matcher<ZonedDateTime> zonedDateTimeEquals(ZonedDateTime expected) {
        return new ZonedDateTimeEqualsInUtcMatcher(expected);
    }
}

