/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.core;

public class InvocationContextHolder {
    private static ThreadLocal<InvocationContext> invocationContext = new InheritableThreadLocal<InvocationContext>();

    public static void updateContext(String testMethodName) {
        boolean executingNewTestcase;
        InvocationContext previousInvocation = InvocationContextHolder.initOrGet();
        boolean bl = executingNewTestcase = previousInvocation.name == null || !previousInvocation.name.equals(testMethodName);
        if (executingNewTestcase) {
            previousInvocation.reset(testMethodName);
        } else {
            previousInvocation.incrementInvocations();
        }
    }

    private static InvocationContext initOrGet() {
        InvocationContext previousInvocation = invocationContext.get();
        if (previousInvocation == null) {
            previousInvocation = new InvocationContext();
            previousInvocation.testExecutorThread = Thread.currentThread();
            invocationContext.set(previousInvocation);
        }
        return previousInvocation;
    }

    public static void initTestExecutorThread(Thread testExecutorThread) {
        InvocationContextHolder.initOrGet().testExecutorThread = testExecutorThread;
    }

    public static Thread getTestExecutorThread() {
        return InvocationContextHolder.initOrGet().testExecutorThread;
    }

    public static String currentSnapshotName() {
        return InvocationContextHolder.initOrGet().getName();
    }

    private static class InvocationContext {
        private String name;
        private Thread testExecutorThread;
        private int invocationCount;

        private InvocationContext() {
            this.incrementInvocations();
        }

        private void incrementInvocations() {
            ++this.invocationCount;
        }

        private void reset(String testMethodName) {
            this.invocationCount = 1;
            this.name = testMethodName;
        }

        private String getName() {
            return this.name + "-" + this.invocationCount;
        }
    }
}

