/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import ie.corballis.fixtures.core.BeanFactory;
import ie.corballis.fixtures.core.ReferenceResolver;
import ie.corballis.fixtures.util.JsonNodeVisitor;
import ie.corballis.fixtures.util.JsonUtils;
import ie.corballis.fixtures.util.VisitedValue;
import java.util.Stack;

public class ReferenceResolverNodeVisitor
implements JsonNodeVisitor {
    private final String referencePrefix;
    private final ReferenceResolver referenceResolver;
    private final BeanFactory beanFactory;

    public ReferenceResolverNodeVisitor(String referencePrefix, ReferenceResolver referenceResolver, BeanFactory beanFactory) {
        this.referencePrefix = referencePrefix;
        this.referenceResolver = referenceResolver;
        this.beanFactory = beanFactory;
    }

    @Override
    public VisitedValue visitElement(JsonNode original, Object newObject, Stack<Object> path) {
        Object append;
        if (original.isTextual()) {
            String value = original.textValue();
            path.push(value);
            if (value.startsWith(this.referencePrefix)) {
                this.validateReference(original, path, this.referencePrefix);
                append = JsonUtils.visitElements(this.referenceResolver.getReferenceNode(original, this.referencePrefix), newObject, path, this);
            } else {
                append = JsonUtils.getPrimitiveValue(original);
            }
            path.pop();
        } else {
            append = JsonUtils.getPrimitiveValue(original);
        }
        return VisitedValue.valueOf(append);
    }

    private void validateReference(JsonNode node, Stack<Object> path, String referencePrefix) {
        String[] referenceParts = node.textValue().split(referencePrefix);
        this.validateReference(path, referencePrefix, referenceParts);
    }

    private void validateReference(Stack<Object> path, String referencePrefix, String[] referenceParts) {
        String helpText = "Every string value starting with " + referencePrefix + " is considered as fixture reference. If you would like to refer to a fixture, please provide a valid fixture name after " + referencePrefix + ", otherwise if you have a non-referring string starting with " + referencePrefix + " then change the default prefix in @Fixture annotation";
        Preconditions.checkArgument((referenceParts.length == 2 ? 1 : 0) != 0, (Object)("Fixture reference value detected without fixture name in " + JsonUtils.pathToReferenceChain(path) + " property. " + helpText));
        String fixtureName = referenceParts[1];
        this.beanFactory.getFixtureAsJsonNode(fixtureName).orElseThrow(() -> new IllegalArgumentException("Fixture reference value detected without existing fixture in " + JsonUtils.pathToReferenceChain(path) + " property. " + helpText));
        boolean hasNoCircularDependency = path.indexOf(referencePrefix + fixtureName) == path.size() - 1;
        Preconditions.checkArgument((boolean)hasNoCircularDependency, (Object)("Circular dependency detected between references: " + JsonUtils.pathToReferenceChain(path)));
    }
}

