/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.io;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import ie.corballis.fixtures.io.Resource;
import ie.corballis.fixtures.settings.Settings;
import ie.corballis.fixtures.util.ClassUtils;
import ie.corballis.fixtures.util.ResourceUtils;
import ie.corballis.fixtures.util.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.reflections.Reflections;

public class ClassPathResource
implements Resource {
    private final String path;
    private ClassLoader classLoader;
    private Class<?> clazz;

    public static List<Resource> collectClasspathResources(Pattern pattern, Reflections reflections) {
        reflections = reflections == null ? Settings.Builder.DEFAULT_REFLECTIONS : reflections;
        Set fixturePaths = reflections.getResources(pattern);
        return ImmutableList.copyOf(ClassPathResource.convertToResources(fixturePaths));
    }

    private static List<Resource> convertToResources(Collection<String> paths) {
        ArrayList resources = Lists.newArrayList();
        for (String path : paths) {
            resources.add(new ClassPathResource(path));
        }
        return resources;
    }

    public ClassPathResource(String path) {
        this(path, (ClassLoader)null);
    }

    public ClassPathResource(String path, ClassLoader classLoader) {
        Preconditions.checkNotNull((Object)path, (Object)"Path must not be null");
        String pathToUse = StringUtils.cleanPath(path);
        if (pathToUse.startsWith("/")) {
            pathToUse = pathToUse.substring(1);
        }
        this.path = pathToUse;
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    public ClassPathResource(String path, Class<?> clazz) {
        Preconditions.checkNotNull((Object)path, (Object)"Path must not be null");
        this.path = StringUtils.cleanPath(path);
        this.clazz = clazz;
    }

    protected ClassPathResource(String path, ClassLoader classLoader, Class<?> clazz) {
        this.path = StringUtils.cleanPath(path);
        this.classLoader = classLoader;
        this.clazz = clazz;
    }

    @Override
    public boolean exists() {
        URL url = this.getUrlFromPath();
        return url != null;
    }

    @Override
    public URL getURL() throws IOException {
        URL url = this.getUrlFromPath();
        if (url == null) {
            throw new FileNotFoundException(this.path + " cannot be resolved to URL because it does not exist");
        }
        return url;
    }

    private URL getUrlFromPath() {
        URL url = this.clazz != null ? this.clazz.getResource(this.path) : this.classLoader.getResource(this.path);
        return url;
    }

    @Override
    public URI getURI() throws IOException {
        URL url = this.getURL();
        try {
            return ResourceUtils.toURI(url);
        }
        catch (URISyntaxException ex) {
            throw new IOException("Invalid URI [" + url + "]", ex);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is = this.clazz != null ? this.clazz.getResourceAsStream(this.path) : this.classLoader.getResourceAsStream(this.path);
        if (is == null) {
            throw new FileNotFoundException(this.path + " cannot be opened because it does not exist");
        }
        return is;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClassPathResource");
        sb.append("[path='").append(this.path).append('\'');
        sb.append(']');
        return sb.toString();
    }
}

