/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.io;

import com.google.common.base.Preconditions;
import ie.corballis.fixtures.io.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

public class FileSystemResource
implements Resource {
    private final File file;

    public FileSystemResource(File file) {
        Preconditions.checkNotNull((Object)file, (Object)"File must not be null");
        this.file = file;
    }

    public FileSystemResource(String path) {
        Preconditions.checkNotNull((Object)path, (Object)"Path must not be null");
        this.file = new File(path);
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public URL getURL() throws IOException {
        return this.file.toURI().toURL();
    }

    @Override
    public URI getURI() throws IOException {
        return this.file.toURI();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }
}

