/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.io.scanner;

import ie.corballis.fixtures.io.ClassPathResource;
import ie.corballis.fixtures.io.Resource;
import ie.corballis.fixtures.io.scanner.FixtureScanner;
import java.util.List;
import java.util.regex.Pattern;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathFixtureScanner
implements FixtureScanner {
    private static final Logger logger = LoggerFactory.getLogger(ClassPathFixtureScanner.class);
    private static final String FIXTURE_REG_EXP = ".*\\.fixtures\\.json";
    private static final Pattern FIXTURE_PATTERN = Pattern.compile(".*\\.fixtures\\.json");
    private final List<Resource> resources;

    public ClassPathFixtureScanner() {
        this(null);
    }

    public ClassPathFixtureScanner(Reflections reflections) {
        this.resources = ClassPathResource.collectClasspathResources(FIXTURE_PATTERN, reflections);
        logger.debug("Detected fixture files: {}", this.resources);
    }

    @Override
    public List<Resource> collectResources() {
        return this.resources;
    }
}

