/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.io.scanner;

import ie.corballis.fixtures.io.FileSystemResource;
import ie.corballis.fixtures.io.Resource;
import ie.corballis.fixtures.io.scanner.FixtureScanner;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FolderFixtureScanner
implements FixtureScanner {
    private static final PathMatcher FIXTURE_PATH_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**.fixtures.json");
    private final List<Resource> resources;

    public FolderFixtureScanner(Class testClass) {
        this.resources = this.collectFixturesInFolder(this.getFolderOfTestClass(testClass));
    }

    private String getFolderOfTestClass(Class testClass) {
        try {
            return Paths.get(testClass.getResource("").toURI()).toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Resource> collectFixturesInFolder(String folder) {
        List<Resource> resources;
        try (Stream<Path> paths = Files.walk(Paths.get(folder, new String[0]), new FileVisitOption[0]);){
            resources = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(this::isFixtureFile).map(path -> new FileSystemResource(path.toString())).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return resources;
    }

    private boolean isFixtureFile(Path path) {
        return FIXTURE_PATH_MATCHER.matches(path);
    }

    public FolderFixtureScanner(String folder) {
        this.resources = this.collectFixturesInFolder(folder);
    }

    @Override
    public List<Resource> collectResources() {
        return this.resources;
    }
}

