/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.io.scanner;

import ie.corballis.fixtures.io.ClassPathResource;
import ie.corballis.fixtures.io.Resource;
import ie.corballis.fixtures.io.scanner.FixtureScanner;
import java.util.List;
import java.util.regex.Pattern;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrefixFixtureScanner
implements FixtureScanner {
    private static final Logger logger = LoggerFactory.getLogger(PrefixFixtureScanner.class);
    private final List<Resource> resources;

    public PrefixFixtureScanner(String pattern) {
        this(pattern, null);
    }

    public PrefixFixtureScanner(String pattern, Reflections reflections) {
        String regex = String.format("%s.*\\.fixtures\\.json", pattern);
        this.resources = ClassPathResource.collectClasspathResources(Pattern.compile(regex), reflections);
        logger.debug("Detected fixture files: {}", this.resources);
    }

    @Override
    public List<Resource> collectResources() {
        return this.resources;
    }
}

