/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.io.write;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import ie.corballis.fixtures.io.write.FileNamingStrategy;
import ie.corballis.fixtures.io.write.FixtureWriter;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;

public abstract class AbstractFixtureWriter
implements FixtureWriter {
    private ObjectMapper objectMapper;

    public AbstractFixtureWriter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public File write(String folder, String fileNamePrefix, String fixtureName, Object contents, FileNamingStrategy namingStrategy, Consumer<Map<String, Object>> contentTransformer) throws IOException {
        String fileName = namingStrategy.getFileName(folder, fileNamePrefix, fixtureName);
        String fixtureFilePath = Joiner.on((String)File.separator).join((Object)folder, (Object)fileName, new Object[0]);
        try {
            File fixtureFile = new File(fixtureFilePath);
            Map fixtureFileContents = Maps.newHashMap();
            if (!fixtureFile.exists()) {
                fixtureFile.createNewFile();
            } else {
                fixtureFileContents = (Map)this.objectMapper.readValue(fixtureFile, Map.class);
            }
            fixtureFileContents.put(fixtureName, contents);
            if (contentTransformer != null) {
                contentTransformer.accept(fixtureFileContents);
            }
            String jsonContent = this.writeFormattedJson(fixtureFileContents);
            FileUtils.writeStringToFile((File)fixtureFile, (String)jsonContent);
            return fixtureFile;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected String writeFormattedJson(Map fixtureFileContents) throws JsonProcessingException {
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)fixtureFileContents);
    }
}

