/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.snapshot;

import com.fasterxml.jackson.databind.JsonNode;
import ie.corballis.fixtures.core.BeanFactory;
import ie.corballis.fixtures.core.InvocationContextHolder;
import ie.corballis.fixtures.io.Resource;
import ie.corballis.fixtures.io.scanner.FixtureScanner;
import ie.corballis.fixtures.settings.SettingsHolder;
import ie.corballis.fixtures.util.ClassUtils;
import java.io.IOException;

public class SnapshotGenerator {
    private final BeanFactory beanFactory;
    private final FixtureScanner scanner;

    public SnapshotGenerator(BeanFactory beanFactory) {
        this(beanFactory, SettingsHolder.settings().getFixtureScanner());
    }

    public SnapshotGenerator(BeanFactory beanFactory, FixtureScanner scanner) {
        this.beanFactory = beanFactory;
        this.scanner = scanner;
    }

    public boolean createOrUpdateFixture(Object actual, boolean regenerateFixture) throws IOException {
        boolean createdOrUpdated = false;
        this.initTest();
        if (this.canGenerateNewSnapshot() || regenerateFixture) {
            Class testClass = ClassUtils.getTestClass();
            SettingsHolder.settings().getSnapshotFixtureWriter().write(testClass, InvocationContextHolder.currentSnapshotName(), actual);
            createdOrUpdated = true;
        }
        return createdOrUpdated;
    }

    private void initTest() {
        String testMethodName = ClassUtils.getTestMethodName();
        InvocationContextHolder.updateContext(testMethodName);
    }

    private boolean canGenerateNewSnapshot() {
        JsonNode snapshotFixture = this.getSnapshotFixtureNode();
        return snapshotFixture == null;
    }

    public JsonNode getSnapshotFixtureNode() {
        return this.beanFactory.getFixtureAsJsonNode(InvocationContextHolder.currentSnapshotName()).orElse(null);
    }

    public String getCurrentSnapshotFixtureName() {
        return InvocationContextHolder.currentSnapshotName();
    }

    public void validateSnapshots() {
        this.scanner.collectResources().stream().map(this::convertToJsonNode).forEach(this::verifyAutoGeneratedClasses);
    }

    private AutoGeneratedResource convertToJsonNode(Resource resource) {
        try {
            return new AutoGeneratedResource(SettingsHolder.settings().getObjectMapper().readTree(resource.getInputStream()), resource);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void verifyAutoGeneratedClasses(AutoGeneratedResource autoGeneratedResource) {
        JsonNode snapshotClass = autoGeneratedResource.node.get("_AUTO_GENERATED_FOR_");
        if (snapshotClass != null) {
            String fullClassName = snapshotClass.textValue();
            try {
                Class.forName(fullClassName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(fullClassName + " does not exist anymore in '" + autoGeneratedResource.getPath() + "' file. If the file has been renamed/removed, please update the value of " + "_AUTO_GENERATED_FOR_" + " property and move the file to the correct location.");
            }
        }
    }

    private static class AutoGeneratedResource {
        private final JsonNode node;
        private final Resource resource;

        AutoGeneratedResource(JsonNode node, Resource resource) {
            this.node = node;
            this.resource = resource;
        }

        public String getPath() {
            try {
                return this.resource.getURI().getPath();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

