/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import ie.corballis.fixtures.util.JsonNodeVisitor;
import ie.corballis.fixtures.util.VisitedValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Stack;

public class JsonUtils {
    public static String pathToReferenceChain(Stack<Object> path) {
        return Joiner.on((String)"->").skipNulls().join(path);
    }

    public static Object getPrimitiveValue(JsonNode original) {
        try {
            if (original.isBoolean()) {
                return original.asBoolean();
            }
            if (original.isNumber()) {
                return original.numberValue();
            }
            if (original.isBinary()) {
                return original.binaryValue();
            }
            if (original.isNull()) {
                return null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return original.textValue();
    }

    public static Object visitElements(JsonNode original, JsonNodeVisitor visitor) {
        return JsonUtils.visitElementsInternal(original, Maps.newHashMap(), new Stack<Object>(), visitor).getValue();
    }

    public static Object visitElements(JsonNode original, Object newObject, Stack<Object> path, JsonNodeVisitor visitor) {
        return JsonUtils.visitElementsInternal(original, newObject, path, visitor).getValue();
    }

    private static VisitedValue visitElementsInternal(JsonNode original, Object newObject, Stack<Object> path, JsonNodeVisitor visitor) {
        if (original.isObject()) {
            Iterator fieldNames = original.fieldNames();
            LinkedHashMap nested = Maps.newLinkedHashMap();
            VisitedValue object = visitor.visitObject(original, path);
            if (object != null) {
                return object;
            }
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                path.push(fieldName);
                JsonNode childNode = original.get(fieldName);
                VisitedValue value = JsonUtils.visitElementsInternal(childNode, nested, path, visitor);
                if (value.isAppendToResult()) {
                    nested.put(fieldName, value.getValue());
                }
                path.pop();
            }
            return VisitedValue.valueOf(nested);
        }
        if (original.isArray()) {
            ArrayList nestedList = Lists.newArrayList();
            VisitedValue object = visitor.visitList(original, path);
            if (object != null) {
                return object;
            }
            for (int i = 0; i < original.size(); ++i) {
                path.push(i);
                VisitedValue value = JsonUtils.visitElementsInternal(original.get(i), nestedList, path, visitor);
                if (value.isAppendToResult()) {
                    nestedList.add(value.getValue());
                }
                path.pop();
            }
            return VisitedValue.valueOf(nestedList);
        }
        return visitor.visitElement(original, newObject, path);
    }
}

