/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.assertion;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import ie.corballis.fixtures.assertion.PropertyMatcherVisitor;
import ie.corballis.fixtures.assertion.PropertyMatchers;
import ie.corballis.fixtures.assertion.matcher.NestedObjectMatcher;
import ie.corballis.fixtures.util.JsonUtils;
import ie.corballis.fixtures.util.VisitedValue;
import java.util.List;
import java.util.Stack;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class PropertyMatcherAssertingVisitor
extends PropertyMatcherVisitor {
    private final PropertyMatchers matchers;
    private final Matcher matcher;

    public PropertyMatcherAssertingVisitor(List<String> propertyChain, PropertyMatchers matchers) {
        super(propertyChain);
        this.matchers = matchers;
        String property = Joiner.on((String)".").join(propertyChain);
        this.matcher = matchers.getMatcher(property);
        Preconditions.checkNotNull((Object)this.matcher, (Object)("Could not find matcher to " + property + ". Please check that you PropertyMatchers are configured properly."));
    }

    @Override
    public VisitedValue visitElement(JsonNode original, Object newObject, Stack<Object> path) {
        Object actualValue = JsonUtils.getPrimitiveValue(original);
        this.executeMatcher(path, actualValue);
        return VisitedValue.valueOf(actualValue);
    }

    private void executeMatcher(Stack<Object> path, Object actualValue) {
        if (this.isMatchingPath(path)) {
            MatcherAssert.assertThat((String)("Property '" + JsonUtils.pathToReferenceChain(path) + "' did not match with the PropertyMatcher you provided. "), (Object)actualValue, (Matcher)this.matcher);
        }
    }

    @Override
    public VisitedValue visitObject(JsonNode original, Stack<Object> path) {
        VisitedValue value = null;
        if (this.isMatchingPath(path)) {
            Preconditions.checkState((boolean)(this.matcher instanceof NestedObjectMatcher), (Object)("Property '" + JsonUtils.pathToReferenceChain(path) + "' is an object. In order to use matchers with an object, you must wrap that in a nested matcher. e.g: nested(equalTo(...), ClassOfNestedObject.class)"));
            this.executeMatcher(path, original);
            value = VisitedValue.skipValue();
        }
        return value;
    }
}

