/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.assertion.matcher;

import ie.corballis.fixtures.settings.SettingsHolder;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public class NestedObjectMatcher<T>
extends BaseMatcher<T> {
    private final Class<T> nestedClass;
    private final Matcher<T> matcher;

    public NestedObjectMatcher(Matcher<T> matcher, Class<T> nestedClass) {
        this.nestedClass = nestedClass;
        this.matcher = matcher;
    }

    @Factory
    public static <T> Matcher<T> nested(Matcher<T> matcher, Class<T> nestedClass) {
        return new NestedObjectMatcher<T>(matcher, nestedClass);
    }

    public boolean matches(Object item) {
        T actual = this.convertTo(item);
        return this.matcher.matches(actual);
    }

    private T convertTo(Object item) {
        Object actual;
        try {
            actual = SettingsHolder.settings().getObjectMapper().convertValue(item, this.nestedClass);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot convert actual value to [" + this.nestedClass.getSimpleName() + "] instance. Make sure that the nested entity is an instance of " + this.nestedClass.getSimpleName(), e);
        }
        return (T)actual;
    }

    public void describeTo(Description description) {
        this.matcher.describeTo(description);
    }
}

