/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import ie.corballis.fixtures.core.ReferenceResolver;
import ie.corballis.fixtures.io.DefaultFixtureReader;
import ie.corballis.fixtures.io.FixtureReader;
import ie.corballis.fixtures.io.Resource;
import ie.corballis.fixtures.io.scanner.FixtureScanner;
import ie.corballis.fixtures.settings.SettingsHolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class BeanFactory {
    public static final String DEFAULT_REFERENCE_PREFIX = "#";
    private ObjectMapper objectMapper;
    private FixtureScanner scanner;
    private FixtureReader reader;
    private ReferenceResolver referenceResolver;
    private volatile boolean initialized = false;
    private Cache<String, JsonNode> fixtures = CacheBuilder.newBuilder().build();

    public BeanFactory() {
        this(SettingsHolder.settings().getObjectMapper(), SettingsHolder.settings().getFixtureScanner());
    }

    public BeanFactory(ObjectMapper objectMapper, FixtureScanner scanner) {
        this.objectMapper = objectMapper;
        this.scanner = scanner;
        this.reader = new DefaultFixtureReader(objectMapper);
        this.referenceResolver = new ReferenceResolver(objectMapper, this);
    }

    public BeanFactory(ObjectMapper objectMapper) {
        this(objectMapper, null);
    }

    public synchronized void init() {
        if (!this.initialized) {
            this.initialized = true;
            try {
                if (this.scanner != null) {
                    List<Resource> resources = this.scanner.collectResources();
                    for (Resource resource : resources) {
                        this.registerAll(this.reader.read(resource));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void registerAll(Map<String, JsonNode> fixtures) {
        this.init();
        Preconditions.checkNotNull(fixtures, (Object)"Fixtures must not be null");
        for (Map.Entry<String, JsonNode> entry : fixtures.entrySet()) {
            this.registerFixture(entry.getKey(), entry.getValue());
        }
    }

    public void registerFixture(String name, JsonNode fixture) {
        this.init();
        Preconditions.checkNotNull((Object)name, (Object)"Name must not be null");
        Preconditions.checkNotNull((Object)fixture, (Object)"Fixture must not be null");
        this.fixtures.put((Object)name, (Object)fixture);
    }

    public void unregisterAll(Collection<String> names) {
        this.init();
        for (String name : names) {
            this.fixtures.invalidate((Object)name);
        }
    }

    public void unregisterFixture(String name) {
        this.init();
        this.fixtures.invalidate((Object)name);
    }

    public void setAllowUnknownProperties(boolean allowUnknownProperties) {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, !allowUnknownProperties);
    }

    public String createAsString(String ... fixtureNames) throws JsonProcessingException {
        return this.createAsString(false, Lists.newArrayList((Object[])fixtureNames));
    }

    public String createAsString(boolean pretty, String ... fixtureNames) throws JsonProcessingException {
        return this.createAsString(pretty, Lists.newArrayList((Object[])fixtureNames));
    }

    public String createAsString(boolean pretty, List<String> fixtureNames) throws JsonProcessingException {
        if (fixtureNames.size() == 0) {
            return "{}";
        }
        JsonNode result = this.mergeFixtures(fixtureNames.toArray(new String[fixtureNames.size()]));
        return this.createAsString(pretty, result);
    }

    public String createAsString(boolean pretty, JsonNode jsonNode) throws JsonProcessingException {
        return pretty ? this.objectMapper.writer().withDefaultPrettyPrinter().writeValueAsString((Object)jsonNode) : jsonNode.toString();
    }

    public <T> T create(Class<T> type, String ... fixtureNames) {
        return this.create(DEFAULT_REFERENCE_PREFIX, type, fixtureNames);
    }

    public <T> T create(JavaType type, String ... fixtureNames) {
        return this.create(DEFAULT_REFERENCE_PREFIX, type, fixtureNames);
    }

    public <T> T create(String referencePrefix, JavaType type, String ... fixtureNames) {
        Preconditions.checkArgument((fixtureNames.length > 0 ? 1 : 0) != 0, (Object)"At least one fixture needs to be specified.");
        JsonNode jsonNode = this.mergeFixtures(fixtureNames);
        return this.referenceResolver.resolve(jsonNode, type, this.getFixtureName(fixtureNames), referencePrefix);
    }

    public <T> T create(String referencePrefix, Class<T> type, String ... fixtureNames) {
        Preconditions.checkArgument((fixtureNames.length > 0 ? 1 : 0) != 0, (Object)"At least one fixture needs to be specified.");
        JsonNode jsonNode = this.mergeFixtures(fixtureNames);
        return this.referenceResolver.resolve(jsonNode, type, this.getFixtureName(fixtureNames), referencePrefix);
    }

    private String getFixtureName(String[] fixtureNames) {
        return fixtureNames.length == 1 ? fixtureNames[0] : "[MERGED:" + Joiner.on((String)",").join((Object[])fixtureNames) + "]";
    }

    private JsonNode getFixtureAsJsonNodeOrFail(String fixtureName) {
        return this.getFixtureAsJsonNode(fixtureName).orElseThrow(() -> new NullPointerException("'" + fixtureName + "' is not a valid fixture name!"));
    }

    public Optional<JsonNode> getFixtureAsJsonNode(String fixtureName) {
        this.init();
        JsonNode fixtureAsJsonNode = (JsonNode)this.fixtures.getIfPresent((Object)fixtureName);
        if (fixtureAsJsonNode == null) {
            return Optional.empty();
        }
        return Optional.of(fixtureAsJsonNode.deepCopy());
    }

    private JsonNode mergeFixtures(String[] fixtureNames) {
        this.init();
        List<JsonNode> fixtureList = this.collectFixtures(fixtureNames);
        JsonNode result = fixtureList.remove(0).deepCopy();
        for (JsonNode node : fixtureList) {
            BeanFactory.merge(result, node);
        }
        return result;
    }

    private List<JsonNode> collectFixtures(String[] fixtureNames) {
        ArrayList fixtureList = Lists.newArrayList();
        for (String fixtureName : fixtureNames) {
            JsonNode fixtureAsJsonNode = this.getFixtureAsJsonNodeOrFail(fixtureName);
            fixtureList.add(fixtureAsJsonNode);
        }
        return fixtureList;
    }

    private static JsonNode merge(JsonNode targetNode, JsonNode sourceNode) {
        Iterator fieldNames = sourceNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode jsonNode = targetNode.get(fieldName);
            if (jsonNode != null && jsonNode.isObject()) {
                BeanFactory.merge(jsonNode, sourceNode.get(fieldName));
                continue;
            }
            if (!(targetNode instanceof ObjectNode)) continue;
            JsonNode value = sourceNode.get(fieldName);
            ((ObjectNode)targetNode).put(fieldName, value);
        }
        return targetNode;
    }
}

