/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.core;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import ie.corballis.fixtures.core.BeanFactory;
import ie.corballis.fixtures.core.ReferenceResolverNodeVisitor;
import ie.corballis.fixtures.util.JsonUtils;
import java.util.Stack;

public class ReferenceResolver {
    private final ObjectMapper objectMapper;
    private final BeanFactory beanFactory;

    public ReferenceResolver(ObjectMapper objectMapper, BeanFactory beanFactory) {
        this.objectMapper = objectMapper;
        this.beanFactory = beanFactory;
    }

    public <T> T resolve(JsonNode original, Class<T> type, String fixtureName, String referencePrefix) {
        Object baseObjectMap = this.resolveAndCreateBaseObjectMap(original, fixtureName, referencePrefix);
        return (T)this.objectMapper.convertValue(baseObjectMap, type);
    }

    public <T> T resolve(JsonNode original, JavaType type, String fixtureName, String referencePrefix) {
        Object baseObjectMap = this.resolveAndCreateBaseObjectMap(original, fixtureName, referencePrefix);
        return (T)this.objectMapper.convertValue(baseObjectMap, type);
    }

    private Object resolveAndCreateBaseObjectMap(JsonNode original, String fixtureName, String referencePrefix) {
        Object baseObjectMap = this.initBaseObject(original, referencePrefix);
        Stack<Object> path = new Stack<Object>();
        path.push(fixtureName);
        baseObjectMap = JsonUtils.visitElements(original, baseObjectMap, path, new ReferenceResolverNodeVisitor(referencePrefix, this, this.beanFactory));
        return baseObjectMap;
    }

    private Object initBaseObject(JsonNode original, String referencePrefix) {
        JsonNode referenceNode = this.getReferenceNode(original, referencePrefix);
        if (original.isObject()) {
            return Maps.newLinkedHashMap();
        }
        if (original.isArray()) {
            return Lists.newArrayList();
        }
        if (referenceNode != null) {
            return this.initBaseObject(referenceNode, referencePrefix);
        }
        throw new IllegalArgumentException("The base object of fixtures must either be a bean, object, map or any collection type. If you need to use primitives add variables into your test class instead. " + original + " is used as value which is not supported.");
    }

    protected JsonNode getReferenceNode(JsonNode node, String referencePrefix) {
        String value;
        JsonNode referenceNode = null;
        if (node.isTextual() && (value = node.textValue()).startsWith(referencePrefix)) {
            String fixtureName = value.substring(referencePrefix.length());
            referenceNode = this.beanFactory.getFixtureAsJsonNode(fixtureName).orElse(null);
        }
        return referenceNode;
    }
}

