/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.io.scanner;

import com.google.common.collect.ImmutableList;
import ie.corballis.fixtures.io.Resource;
import ie.corballis.fixtures.io.scanner.FixtureScanner;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CompositeFixtureScanner
implements FixtureScanner {
    private final List<FixtureScanner> scanners;

    public CompositeFixtureScanner(FixtureScanner ... scanners) {
        this((List<FixtureScanner>)ImmutableList.copyOf((Object[])scanners));
    }

    public CompositeFixtureScanner(List<FixtureScanner> scanners) {
        this.scanners = scanners;
    }

    @Override
    public List<Resource> collectResources() {
        HashSet uris = new HashSet();
        return this.scanners.stream().flatMap(scanner -> scanner.collectResources().stream()).filter(resource -> this.uniqueResource((Resource)resource, uris)).collect(Collectors.toList());
    }

    private boolean uniqueResource(Resource resource, Set<URI> uris) {
        try {
            return uris.add(resource.getURI());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

