/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.io.scanner;

import ie.corballis.fixtures.io.ClassPathResource;
import ie.corballis.fixtures.io.Resource;
import ie.corballis.fixtures.io.scanner.FixtureScanner;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrefixFixtureScanner
implements FixtureScanner {
    private static final Logger logger = LoggerFactory.getLogger(PrefixFixtureScanner.class);
    private final Pattern pattern;
    private List<Resource> resources;

    public PrefixFixtureScanner(String pattern) {
        this.pattern = Pattern.compile(String.format("%s.*\\.fixtures\\.json", pattern));
    }

    @Override
    public synchronized List<Resource> collectResources() {
        if (this.resources == null) {
            this.resources = ClassPathResource.collectClasspathResources(this.pattern);
            logger.debug("Detected fixture files: {}", this.resources);
        }
        return this.resources;
    }
}

