/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.io.write;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import ie.corballis.fixtures.io.write.AbstractFixtureWriter;
import ie.corballis.fixtures.io.write.SnapshotFixtureWriter;
import ie.corballis.fixtures.settings.SettingsHolder;
import ie.corballis.fixtures.util.ClassUtils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.regex.Matcher;

public class DefaultSnapshotWriter
extends AbstractFixtureWriter
implements SnapshotFixtureWriter {
    public static final String AUTO_GENERATED_FOR = "_AUTO_GENERATED_FOR_";

    public DefaultSnapshotWriter(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    public File write(Class testClass, String fixtureName, Object contents) throws IOException {
        try {
            String fixtureFileName = testClass.getSimpleName();
            String fixtureFileFolder = this.getFixtureFileFolder(testClass);
            return this.write(fixtureFileFolder, fixtureFileName, fixtureName, contents, SettingsHolder.settings().getSnapshotFileNamingStrategy(), contentMap -> this.appendAutoGeneratedFor(testClass, (Map<String, Object>)contentMap));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected Object appendAutoGeneratedFor(Class testClass, Map<String, Object> contentMap) {
        return contentMap.put(AUTO_GENERATED_FOR, testClass.getName());
    }

    protected String getFixtureFileFolder(Class testClass) throws URISyntaxException {
        URL fileUrl = ClassUtils.getTestClass().getProtectionDomain().getCodeSource().getLocation();
        File file = new File(fileUrl.toURI());
        String projectRoot = file.getParentFile().getParent();
        String folderOfClass = testClass.getPackage().getName().replaceAll("\\.", Matcher.quoteReplacement(File.separator));
        return Joiner.on((String)File.separator).join((Iterable)Lists.newArrayList((Object[])new String[]{projectRoot, "src", "test", "java", folderOfClass}));
    }
}

