/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.settings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import ie.corballis.fixtures.core.BeanFactory;
import ie.corballis.fixtures.io.scanner.ClassPathFixtureScanner;
import ie.corballis.fixtures.io.scanner.CompositeFixtureScanner;
import ie.corballis.fixtures.io.scanner.FixtureScanner;
import ie.corballis.fixtures.io.scanner.FolderFixtureScanner;
import ie.corballis.fixtures.io.scanner.TestFileNameFixtureScanner;
import ie.corballis.fixtures.io.write.DefaultSnapshotWriter;
import ie.corballis.fixtures.io.write.FileNamingStrategy;
import ie.corballis.fixtures.io.write.FixtureWriter;
import ie.corballis.fixtures.io.write.JsonFixturesPrettyPrinter;
import ie.corballis.fixtures.io.write.SnapshotFixtureWriter;
import ie.corballis.fixtures.io.write.StaticPathDefaultSnapshotWriter;
import ie.corballis.fixtures.io.write.TestClassFileNamingStrategy;
import ie.corballis.fixtures.snapshot.SnapshotGenerator;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.util.ClasspathHelper;

public class Settings {
    private final ObjectMapper objectMapper;
    private final FileNamingStrategy snapshotFileNamingStrategy;
    private final FileNamingStrategy generatorFileNamingStrategy;
    private final SnapshotFixtureWriter snapshotFixtureWriter;
    private final FixtureScanner fixtureScanner;
    private final BeanFactory beanFactory;
    private final SnapshotGenerator snapshotGenerator;
    private final Reflections reflections;

    public Settings(Builder builder) {
        this.objectMapper = builder.objectMapper;
        this.snapshotFileNamingStrategy = builder.snapshotFileNamingStrategy;
        this.generatorFileNamingStrategy = builder.generatorFileNamingStrategy;
        this.snapshotFixtureWriter = builder.snapshotFixtureWriter;
        this.fixtureScanner = builder.fixtureScanner;
        this.reflections = builder.getReflections();
        this.beanFactory = new BeanFactory(this.objectMapper, this.fixtureScanner);
        this.snapshotGenerator = new SnapshotGenerator(this.beanFactory, this.fixtureScanner);
    }

    public static Settings defaultSettings() {
        return new Builder().build();
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public FileNamingStrategy getSnapshotFileNamingStrategy() {
        return this.snapshotFileNamingStrategy;
    }

    public SnapshotFixtureWriter getSnapshotFixtureWriter() {
        return this.snapshotFixtureWriter;
    }

    public FileNamingStrategy getGeneratorFileNamingStrategy() {
        return this.generatorFileNamingStrategy;
    }

    public FixtureScanner getFixtureScanner() {
        return this.fixtureScanner;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public SnapshotGenerator getSnapshotGenerator() {
        return this.snapshotGenerator;
    }

    public Reflections getReflections() {
        return this.reflections;
    }

    public static class Builder {
        private FixtureScanner fixtureScanner;
        private FileNamingStrategy snapshotFileNamingStrategy;
        private FileNamingStrategy generatorFileNamingStrategy;
        private SnapshotFixtureWriter snapshotFixtureWriter;
        private ObjectMapper objectMapper;
        private Reflections reflections;

        public Builder() {
            TestClassFileNamingStrategy fileNamingStrategy = TestClassFileNamingStrategy.getInstance();
            this.setDefaultObjectMapper();
            this.setDefaultSnapshotWriter();
            this.setDefaultFixtureScanner();
            this.setSnapshotFileNamingStrategy(fileNamingStrategy);
            this.setGeneratorFileNamingStrategy(fileNamingStrategy);
        }

        public Builder setDefaultObjectMapper() {
            this.objectMapper = Builder.defaultObjectMapper();
            return this;
        }

        public static ObjectMapper defaultObjectMapper() {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            objectMapper.setDefaultPrettyPrinter((PrettyPrinter)new JsonFixturesPrettyPrinter());
            objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            return objectMapper;
        }

        public Builder setDefaultSnapshotWriter() {
            Preconditions.checkNotNull((Object)this.objectMapper, (Object)"You must set ObjectMapper first to instantiate DefaultSnapshotWriter");
            return this.setSnapshotFixtureWriter(new DefaultSnapshotWriter(this.objectMapper));
        }

        public Builder setDefaultFixtureScanner() {
            return this.setFixtureScanner(new ClassPathFixtureScanner());
        }

        public Builder setFixtureScanner(FixtureScanner fixtureScanner) {
            this.fixtureScanner = fixtureScanner;
            return this;
        }

        public Reflections getReflections() {
            if (this.reflections == null) {
                this.reflections = new Reflections(new Object[]{ClasspathHelper.forJavaClassPath(), new ResourcesScanner()});
            }
            return this.reflections;
        }

        public Builder setReflections(Reflections reflections) {
            this.reflections = reflections;
            return this;
        }

        public ObjectMapper getObjectMapper() {
            return this.objectMapper;
        }

        public Builder setObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public FileNamingStrategy getSnapshotFileNamingStrategy() {
            return this.snapshotFileNamingStrategy;
        }

        public Builder setSnapshotFileNamingStrategy(FileNamingStrategy snapshotFileNamingStrategy) {
            this.snapshotFileNamingStrategy = snapshotFileNamingStrategy;
            return this;
        }

        public FileNamingStrategy getGeneratorFileNamingStrategy() {
            return this.generatorFileNamingStrategy;
        }

        public Builder setGeneratorFileNamingStrategy(FileNamingStrategy snapshotFileNamingStrategy) {
            this.generatorFileNamingStrategy = snapshotFileNamingStrategy;
            return this;
        }

        public FixtureWriter getSnapshotFixtureWriter() {
            return this.snapshotFixtureWriter;
        }

        public Builder setSnapshotFixtureWriter(SnapshotFixtureWriter snapshotFixtureWriter) {
            this.snapshotFixtureWriter = snapshotFixtureWriter;
            return this;
        }

        public Builder setSnapshotFolderPath(String snapshotFolderPath) {
            this.snapshotFixtureWriter = new StaticPathDefaultSnapshotWriter(snapshotFolderPath, this.objectMapper);
            return this;
        }

        public Builder useTestFileNameFixtureScanner(Class testClass) {
            return this.setFixtureScanner(new TestFileNameFixtureScanner(testClass));
        }

        public Builder useFolderFixtureScanner(Class testClass) {
            return this.setFixtureScanner(new FolderFixtureScanner(testClass));
        }

        public Builder useFolderFixtureScanner(String path) {
            return this.setFixtureScanner(new FolderFixtureScanner(path));
        }

        public Builder useCompositeFixtureScanner(FixtureScanner ... scanners) {
            return this.setFixtureScanner(new CompositeFixtureScanner(scanners));
        }

        public Settings build() {
            return new Settings(this);
        }
    }
}

