/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp;

import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class Address
implements Serializable {
    static final long serialVersionUID = -1899181032052084902L;
    private int ton = 0;
    private int npi = 0;
    private String address = "";

    public Address() {
    }

    public Address(int ton, int npi, String address) {
        this.ton = ton;
        this.npi = npi;
        this.address = address;
    }

    public int getTON() {
        return this.ton;
    }

    public void setTON(int ton) {
        this.ton = ton;
    }

    public int getNPI() {
        return this.npi;
    }

    public void setNPI(int npi) {
        this.npi = npi;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address != null ? address : "";
    }

    public int hashCode() {
        StringBuffer buf = new StringBuffer();
        buf.append(Integer.toString(this.ton)).append(':');
        buf.append(Integer.toString(this.npi)).append(':');
        if (this.address != null) {
            buf.append(this.address);
        }
        return buf.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Address) {
            Address a = (Address)obj;
            return a.ton == this.ton && a.npi == this.npi && a.address.equals(this.address);
        }
        return false;
    }

    public int getLength() {
        return 3 + this.address.length();
    }

    public void writeTo(OutputStream out) throws IOException {
        SMPPIO.writeInt(this.ton, 1, out);
        SMPPIO.writeInt(this.npi, 1, out);
        SMPPIO.writeCString(this.address, out);
    }

    public void readFrom(byte[] addr, int offset) {
        this.ton = SMPPIO.bytesToInt(addr, offset++, 1);
        this.npi = SMPPIO.bytesToInt(addr, offset++, 1);
        this.address = SMPPIO.readCString(addr, offset);
    }

    public String toString() {
        return new StringBuffer(25).append(Integer.toString(this.ton)).append(':').append(Integer.toString(this.npi)).append(':').append(this.address).toString();
    }
}

