/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.Address;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.LogFactory;

public class DestinationTable
implements Cloneable {
    private List dests = new ArrayList();
    private int length;
    static /* synthetic */ Class class$ie$omk$smpp$message$DestinationTable;

    DestinationTable() {
    }

    synchronized void add(Address addr) {
        this.dests.add(addr);
        this.length += addr.getLength() + 1;
    }

    synchronized void add(String distList) {
        this.dests.add(distList);
        this.length += distList.length() + 2;
    }

    public synchronized void remove(Address addr) {
        int i = this.dests.indexOf(addr);
        if (i > -1) {
            this.length -= ((Address)this.dests.remove(i)).getLength() + 1;
        }
    }

    public synchronized void remove(String distList) {
        int i = this.dests.indexOf(distList);
        if (i > -1) {
            this.length -= ((String)this.dests.remove(i)).length() + 2;
        }
    }

    public Iterator iterator() {
        return Collections.unmodifiableList(this.dests).iterator();
    }

    public ListIterator listIterator() {
        return Collections.unmodifiableList(this.dests).listIterator();
    }

    public synchronized int getLength() {
        return this.length;
    }

    public int size() {
        return this.dests.size();
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        Iterator i = this.dests.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof Address) {
                SMPPIO.writeInt(1, 1, out);
                ((Address)o).writeTo(out);
                continue;
            }
            SMPPIO.writeInt(2, 1, out);
            SMPPIO.writeCString((String)o, out);
        }
    }

    public synchronized void readFrom(byte[] table, int offset, int count) {
        for (int i = 0; i < count; ++i) {
            int type;
            if ((type = SMPPIO.bytesToInt(table, offset++, 1)) == 1) {
                Address a = new Address();
                a.readFrom(table, offset);
                offset += a.getLength();
                this.dests.add(a);
                continue;
            }
            if (type == 2) {
                String d = SMPPIO.readCString(table, offset);
                offset += d.length() + 1;
                this.dests.add(d);
                continue;
            }
            LogFactory.getLog((Class)(class$ie$omk$smpp$message$DestinationTable == null ? DestinationTable.class$("ie.omk.smpp.message.DestinationTable") : class$ie$omk$smpp$message$DestinationTable)).warn((Object)"Unidentified destination type on input.");
        }
        this.calculateLength();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException("Clone not supported", x);
        }
    }

    private void calculateLength() {
        this.length = 0;
        Iterator i = this.dests.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            ++this.length;
            if (o instanceof Address) {
                this.length += ((Address)o).getLength();
                continue;
            }
            this.length += ((String)o).length() + 1;
        }
    }
}

