/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.Address;
import ie.omk.smpp.message.InvalidParameterValueException;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.tlv.TLVTable;
import ie.omk.smpp.message.tlv.Tag;
import ie.omk.smpp.util.AlphabetEncoding;
import ie.omk.smpp.util.BinaryEncoding;
import ie.omk.smpp.util.EncodingFactory;
import ie.omk.smpp.util.MessageEncoding;
import ie.omk.smpp.util.SMPPDate;
import ie.omk.smpp.util.SMPPIO;
import ie.omk.smpp.version.SMPPVersion;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

public abstract class SMPPPacket {
    public static final int GENERIC_NACK = Integer.MIN_VALUE;
    public static final int BIND_RECEIVER = 1;
    public static final int BIND_RECEIVER_RESP = -2147483647;
    public static final int BIND_TRANSMITTER = 2;
    public static final int BIND_TRANSMITTER_RESP = -2147483646;
    public static final int QUERY_SM = 3;
    public static final int QUERY_SM_RESP = -2147483645;
    public static final int SUBMIT_SM = 4;
    public static final int SUBMIT_SM_RESP = -2147483644;
    public static final int DELIVER_SM = 5;
    public static final int DELIVER_SM_RESP = -2147483643;
    public static final int UNBIND = 6;
    public static final int UNBIND_RESP = -2147483642;
    public static final int REPLACE_SM = 7;
    public static final int REPLACE_SM_RESP = -2147483641;
    public static final int CANCEL_SM = 8;
    public static final int CANCEL_SM_RESP = -2147483640;
    public static final int BIND_TRANSCEIVER = 9;
    public static final int BIND_TRANSCEIVER_RESP = -2147483639;
    public static final int OUTBIND = 11;
    public static final int ENQUIRE_LINK = 21;
    public static final int ENQUIRE_LINK_RESP = -2147483627;
    public static final int SUBMIT_MULTI = 33;
    public static final int SUBMIT_MULTI_RESP = -2147483615;
    public static final int PARAM_RETRIEVE = 34;
    public static final int PARAM_RETRIEVE_RESP = -2147483614;
    public static final int QUERY_LAST_MSGS = 35;
    public static final int QUERY_LAST_MSGS_RESP = -2147483613;
    public static final int QUERY_MSG_DETAILS = 36;
    public static final int QUERY_MSG_DETAILS_RESP = -2147483612;
    public static final int ALERT_NOTIFICATION = 258;
    public static final int DATA_SM = 259;
    public static final int DATA_SM_RESP = -2147483389;
    public static final int SM_STATE_EN_ROUTE = 1;
    public static final int SM_STATE_DELIVERED = 2;
    public static final int SM_STATE_EXPIRED = 3;
    public static final int SM_STATE_DELETED = 4;
    public static final int SM_STATE_UNDELIVERABLE = 5;
    public static final int SM_STATE_ACCEPTED = 6;
    public static final int SM_STATE_INVALID = 7;
    public static final int SMC_MT = 1;
    public static final int SMC_MO = 2;
    public static final int SMC_MOMT = 3;
    public static final int SMC_RECEIPT = 4;
    public static final int SMC_DEFMSG = 8;
    public static final int SMC_LOOPBACK_RECEIPT = 16;
    public static final int SMC_RECEIPT_SWAP = 20;
    public static final int SMC_STORE = 32;
    public static final int SMC_STORE_FORWARD = 36;
    public static final int SMC_DLIST = 64;
    public static final int SMC_MULTI = 128;
    public static final int SMC_CAS_DL = 256;
    public static final int SMC_ESCALATED = 512;
    public static final int SMC_SUBMIT_REPLACE = 1024;
    public static final int SMC_MCE = 2048;
    public static final int ESME_ROK = 0;
    protected SMPPVersion version = SMPPVersion.getDefaultVersion();
    protected int commandId;
    protected int commandStatus;
    protected int sequenceNum;
    protected Address source;
    protected Address destination;
    protected byte[] message;
    protected String serviceType;
    protected SMPPDate deliveryTime;
    protected SMPPDate expiryTime;
    protected SMPPDate finalDate;
    protected String messageId;
    protected int messageStatus;
    protected int errorCode;
    protected int priority;
    protected int registered;
    protected int replaceIfPresent;
    protected int esmClass;
    protected int protocolID;
    private MessageEncoding encoding = EncodingFactory.getInstance().getDefaultAlphabet();
    protected int dataCoding = this.encoding.getDataCoding();
    protected int defaultMsg;
    protected TLVTable tlvTable = new TLVTable();

    protected SMPPPacket(int id) {
        this(id, 0);
    }

    protected SMPPPacket(int id, int seqNum) {
        this.commandId = id;
        this.sequenceNum = seqNum;
    }

    protected SMPPPacket(int id, SMPPVersion version) {
        this.commandId = id;
        this.version = version;
    }

    protected SMPPPacket(int id, int seqNum, SMPPVersion version) {
        this.commandId = id;
        this.sequenceNum = seqNum;
        this.version = version;
    }

    public SMPPVersion getVersion() {
        return this.version;
    }

    public boolean isRequest() {
        return false;
    }

    public void setVersion(SMPPVersion version) {
        this.version = version == null ? SMPPVersion.getDefaultVersion() : version;
    }

    public final int getCommandLen() {
        return this.getLength();
    }

    public final int getLength() {
        return 16 + this.getBodyLength() + this.tlvTable.getLength();
    }

    public abstract int getBodyLength();

    public int getCommandId() {
        return this.commandId;
    }

    public int getCommandStatus() {
        return this.commandStatus;
    }

    public int getSequenceNum() {
        return this.sequenceNum;
    }

    public void setSequenceNum(int sequenceNum) {
        this.sequenceNum = sequenceNum;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSource(Address s) throws InvalidParameterValueException {
        if (s != null) {
            if (!this.version.validateAddress(s)) throw new InvalidParameterValueException("Bad source address.", s);
            this.source = s;
            return;
        } else {
            this.source = null;
        }
    }

    public Address getSource() {
        return this.source;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDestination(Address s) {
        if (s != null) {
            if (!this.version.validateAddress(s)) throw new InvalidParameterValueException("Bad destination address.", s);
            this.destination = s;
            return;
        } else {
            this.destination = null;
        }
    }

    public Address getDestination() {
        return this.destination;
    }

    public void setPriority(int p) throws InvalidParameterValueException {
        if (!this.version.validatePriorityFlag(p)) {
            throw new InvalidParameterValueException("Bad priority flag value", p);
        }
        this.priority = p;
    }

    public void setRegistered(boolean b) {
        this.registered = b ? 1 : 0;
    }

    public void setRegistered(int r) throws InvalidParameterValueException {
        if (!this.version.validateRegisteredDelivery(r)) {
            throw new InvalidParameterValueException("Bad registered delivery flag value", r);
        }
        this.registered = r;
    }

    public void setReplaceIfPresent(boolean b) {
        this.replaceIfPresent = b ? 1 : 0;
    }

    public void setReplaceIfPresent(int rip) throws InvalidParameterValueException {
        if (!this.version.validateReplaceIfPresent(rip)) {
            throw new InvalidParameterValueException("Bad replace if present flag value", rip);
        }
        this.replaceIfPresent = rip;
    }

    public void setEsmClass(int c) throws InvalidParameterValueException {
        if (!this.version.validateEsmClass(c)) {
            throw new InvalidParameterValueException("Bad ESM class", c);
        }
        this.esmClass = c;
    }

    public void setProtocolId(int id) {
        this.protocolID = id;
    }

    public void setProtocolID(int id) throws InvalidParameterValueException {
        if (!this.version.validateProtocolID(id)) {
            throw new InvalidParameterValueException("Bad Protocol ID", id);
        }
        this.protocolID = id;
    }

    public void setDataCoding(int dc) throws InvalidParameterValueException {
        if (this.version.validateDataCoding(dc)) {
            this.dataCoding = dc;
            if (dc > 0) {
                this.encoding = EncodingFactory.getInstance().getEncoding(dc);
            }
        } else {
            throw new InvalidParameterValueException("Bad data coding", dc);
        }
    }

    public void setDefaultMsg(int id) throws InvalidParameterValueException {
        if (!this.version.validateDefaultMsg(id)) {
            throw new InvalidParameterValueException("Default message ID out of range", id);
        }
        this.defaultMsg = id;
    }

    public boolean isRegistered() {
        return this.registered > 0;
    }

    public int getRegistered() {
        return this.registered;
    }

    public boolean isPriority() {
        return this.priority != 0;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isReplaceIfPresent() {
        return this.replaceIfPresent > 0;
    }

    public int getReplaceIfPresent() {
        return this.replaceIfPresent;
    }

    public int getEsmClass() {
        return this.esmClass;
    }

    public int getProtocolId() {
        return this.protocolID;
    }

    public int getProtocolID() {
        return this.protocolID;
    }

    public int getDataCoding() {
        return this.dataCoding;
    }

    public int getDefaultMsgId() {
        return this.defaultMsg;
    }

    public int getDefaultMsg() {
        return this.defaultMsg;
    }

    public void setMessageText(String text) throws InvalidParameterValueException {
        if (!(this.encoding instanceof AlphabetEncoding)) {
            this.encoding = EncodingFactory.getInstance().getDefaultAlphabet();
        }
        AlphabetEncoding a = (AlphabetEncoding)this.encoding;
        this.setMessage(a.encodeString(text), a);
    }

    public void setMessageText(String text, AlphabetEncoding alphabet) throws InvalidParameterValueException {
        if (alphabet == null) {
            throw new NullPointerException("Alphabet cannot be null");
        }
        this.setMessage(alphabet.encodeString(text), alphabet);
    }

    public void setMessage(byte[] message) throws InvalidParameterValueException {
        this.setMessage(message, 0, message.length, null);
    }

    public void setMessage(byte[] message, MessageEncoding encoding) throws InvalidParameterValueException {
        this.setMessage(message, 0, message.length, encoding);
    }

    public void setMessage(byte[] message, int start, int len, MessageEncoding encoding) throws InvalidParameterValueException {
        int dcs = -1;
        if (encoding == null) {
            encoding = new BinaryEncoding();
        }
        dcs = encoding.getDataCoding();
        if (message != null) {
            if (start < 0 || len < 0 || message.length < start + len) {
                throw new ArrayIndexOutOfBoundsException("Not enough bytes in array");
            }
            int encodedLength = len;
            int encodingLength = encoding.getEncodingLength();
            if (encodingLength != 8) {
                encodedLength = len * encodingLength / 8;
            }
            if (encodedLength > this.version.getMaxLength(5)) {
                throw new InvalidParameterValueException("Message is too long", message);
            }
            this.message = new byte[len];
            System.arraycopy(message, start, this.message, 0, len);
            this.dataCoding = dcs;
        } else {
            this.message = null;
        }
    }

    public byte[] getMessage() {
        byte[] b = null;
        if (this.message != null) {
            b = new byte[this.message.length];
            System.arraycopy(this.message, 0, b, 0, b.length);
        }
        return b;
    }

    public String getMessageText() {
        if (this.encoding instanceof AlphabetEncoding) {
            return ((AlphabetEncoding)this.encoding).decodeString(this.message);
        }
        return null;
    }

    public String getMessageText(AlphabetEncoding enc) {
        return enc.decodeString(this.message);
    }

    public int getMessageLen() {
        return this.message == null ? 0 : this.message.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setServiceType(String type) throws InvalidParameterValueException {
        if (type != null) {
            if (!this.version.validateServiceType(type)) throw new InvalidParameterValueException("Bad service type", type);
            this.serviceType = type;
            return;
        } else {
            this.serviceType = null;
        }
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setDeliveryTime(SMPPDate d) {
        this.deliveryTime = d;
    }

    public void setDeliveryTime(Date d) {
        this.deliveryTime = new SMPPDate(d);
    }

    public SMPPDate getDeliveryTime() {
        return this.deliveryTime;
    }

    public void setExpiryTime(SMPPDate d) {
        this.expiryTime = d;
    }

    public void setExpiryTime(Date d) {
        this.expiryTime = new SMPPDate(d);
    }

    public SMPPDate getExpiryTime() {
        return this.expiryTime;
    }

    public void setFinalDate(SMPPDate d) {
        this.finalDate = d;
    }

    public void setFinalDate(Date d) {
        this.finalDate = new SMPPDate(d);
    }

    public SMPPDate getFinalDate() {
        return this.finalDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMessageId(String id) throws InvalidParameterValueException {
        if (id != null) {
            if (!this.version.validateMessageId(id)) throw new InvalidParameterValueException("Bad message Id", id);
            this.messageId = id;
            return;
        } else {
            this.messageId = null;
        }
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageStatus(int st) throws InvalidParameterValueException {
        if (!this.version.validateMessageState(st)) {
            throw new InvalidParameterValueException("Invalid message state", st);
        }
        this.messageStatus = st;
    }

    public int getMessageStatus() {
        return this.messageStatus;
    }

    public void setErrorCode(int code) throws InvalidParameterValueException {
        if (!this.version.validateErrorCode(code)) {
            throw new InvalidParameterValueException("Invalid error code", code);
        }
        this.errorCode = code;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public TLVTable getTLVTable() {
        return this.tlvTable;
    }

    public TLVTable setTLVTable(TLVTable table) {
        TLVTable t = this.tlvTable;
        this.tlvTable = table == null ? new TLVTable() : table;
        return t;
    }

    public Object setOptionalParameter(Tag tag, Object value) {
        return this.tlvTable.set(tag, value);
    }

    public Object getOptionalParameter(Tag tag) {
        return this.tlvTable.get(tag);
    }

    public boolean isSet(Tag tag) {
        return this.tlvTable.isSet(tag);
    }

    public void setAlphabet(AlphabetEncoding enc) {
        this.encoding = enc == null ? EncodingFactory.getInstance().getDefaultAlphabet() : enc;
        this.dataCoding = enc.getDataCoding();
    }

    public void setAlphabet(AlphabetEncoding enc, int dcs) {
        this.encoding = enc == null ? EncodingFactory.getInstance().getDefaultAlphabet() : enc;
        this.dataCoding = dcs;
    }

    public void setMessageEncoding(MessageEncoding enc) {
        this.encoding = enc == null ? EncodingFactory.getInstance().getDefaultAlphabet() : enc;
    }

    public MessageEncoding getMessageEncoding() {
        return this.encoding;
    }

    public String toString() {
        return "SMPP(l:" + Integer.toString(this.getLength()) + ", c:0x" + Integer.toHexString(this.commandId) + ", s:" + Integer.toString(this.commandStatus) + ", n:" + Integer.toString(this.sequenceNum) + ")";
    }

    protected void encodeBody(OutputStream out) throws IOException {
    }

    public final void writeTo(OutputStream out) throws IOException {
        this.writeTo(out, true);
    }

    public final void writeTo(OutputStream out, boolean withOptional) throws IOException {
        int commandLen = this.getLength();
        SMPPIO.writeInt(commandLen, 4, out);
        SMPPIO.writeInt(this.commandId, 4, out);
        SMPPIO.writeInt(this.commandStatus, 4, out);
        SMPPIO.writeInt(this.sequenceNum, 4, out);
        this.encodeBody(out);
        if (withOptional) {
            this.tlvTable.writeTo(out);
        }
    }

    public void readFrom(byte[] b, int offset) throws SMPPProtocolException {
        this.tlvTable.clear();
        if (b.length < offset + 16) {
            throw new SMPPProtocolException("Not enough bytes for a header: " + (b.length - (offset + 16)));
        }
        int len = SMPPIO.bytesToInt(b, offset, 4);
        int id = SMPPIO.bytesToInt(b, offset + 4, 4);
        if (id != this.commandId) {
            throw new SMPPProtocolException("The packet on the input stream is not the same as this packet's type.");
        }
        if (b.length < offset + len) {
            throw new SMPPProtocolException("Header specifies the packet length is longer than the number of bytes available.");
        }
        this.commandStatus = SMPPIO.bytesToInt(b, offset + 8, 4);
        this.sequenceNum = SMPPIO.bytesToInt(b, offset + 12, 4);
        try {
            if (this.commandStatus == 0) {
                int ptr = 16 + offset;
                this.readBodyFrom(b, ptr);
                int bl = this.getBodyLength();
                if ((len -= 16 + bl) > 0) {
                    this.tlvTable.readFrom(b, ptr + bl, len);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException x) {
            throw new SMPPProtocolException("Ran out of bytes to read for packet body", x);
        }
        if (this.dataCoding != 0) {
            this.encoding = EncodingFactory.getInstance().getEncoding(this.dataCoding);
        }
        if (this.encoding == null) {
            this.encoding = EncodingFactory.getInstance().getDefaultAlphabet();
        }
    }

    protected abstract void readBodyFrom(byte[] var1, int var2) throws SMPPProtocolException;
}

