/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message.tlv;

import ie.omk.smpp.message.tlv.BadValueTypeException;
import ie.omk.smpp.message.tlv.Encoder;
import ie.omk.smpp.message.tlv.Tag;
import java.util.BitSet;

public class BitmaskEncoder
implements Encoder {
    public void writeTo(Tag tag, Object value, byte[] b, int offset) {
        try {
            BitSet bs = (BitSet)value;
            int l = tag.getLength();
            for (int i = 0; i < l; ++i) {
                b[offset + i] = 0;
                for (int j = 0; j < 8; ++j) {
                    if (!bs.get(i * 8 + j)) continue;
                    int n = offset + i;
                    b[n] = (byte)(b[n] | (byte)(1 << j));
                }
            }
        }
        catch (ClassCastException x) {
            throw new BadValueTypeException("Value must be of type java.util.BitSet");
        }
    }

    public Object readFrom(Tag tag, byte[] b, int offset, int length) {
        BitSet bs = new BitSet();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < 8; ++j) {
                if ((b[offset + i] & (byte)(1 << j)) == 0) continue;
                bs.set(i * 8 + j);
            }
        }
        return bs;
    }

    public int getValueLength(Tag tag, Object value) {
        return tag.getLength();
    }
}

