/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.net;

import ie.omk.smpp.message.SMPPPacket;
import ie.omk.smpp.message.SMPPRequest;
import ie.omk.smpp.message.SMPPResponse;
import ie.omk.smpp.net.SmscLink;
import ie.omk.smpp.util.SMPPIO;
import ie.omk.smpp.util.SequenceNumberScheme;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectLink
extends SmscLink {
    private static final Log LOGGER = LogFactory.getLog((Class)ObjectLink.class);
    private List packets = new ArrayList();
    private ByteArrayInputStream in;
    private OLByteArrayOutputStream out;
    private boolean connected;
    private int requestSent;
    private int timeout;

    protected void implOpen() throws IOException {
        this.out = new OLByteArrayOutputStream();
    }

    protected void implClose() throws IOException {
    }

    protected OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    protected InputStream getInputStream() throws IOException {
        return this.in;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setSequenceNumberScheme(SequenceNumberScheme seqNumScheme) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(SMPPPacket pak, boolean withOptional) throws IOException {
        super.write(pak, withOptional);
        if (pak instanceof SMPPRequest) {
            ObjectLink objectLink = this;
            synchronized (objectLink) {
                ++this.requestSent;
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(byte[] buf) throws IOException {
        Object next = this.packets.remove(0);
        while (!(next instanceof SMPPPacket)) {
            block12: {
                if (next instanceof Long) {
                    long delay = ((Number)next).longValue();
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException x) {
                        if (!LOGGER.isDebugEnabled()) break block12;
                        LOGGER.debug((Object)"Thread was interrupted while delaying  packet reception.");
                    }
                }
            }
            next = this.packets.remove(0);
        }
        SMPPPacket pak = (SMPPPacket)next;
        if (pak instanceof SMPPResponse) {
            ObjectLink objectLink = this;
            synchronized (objectLink) {
                try {
                    if (this.requestSent < 1) {
                        this.wait(this.timeout);
                    }
                }
                catch (InterruptedException x) {
                    throw new IOException("No packets available.");
                }
            }
            if (this.requestSent < 1) {
                throw new SocketTimeoutException("Timed out waiting on packet");
            }
        }
        int l = pak.getLength();
        this.out.setBuf(buf, l);
        pak.writeTo(this.out);
        return this.out.getBuf();
    }

    public void add(SMPPPacket pak) {
        this.packets.add(pak);
    }

    public void addDelay(long milliseconds) {
        if (milliseconds > 0L) {
            this.packets.add(new Long(milliseconds));
        }
    }

    private class OLByteArrayOutputStream
    extends OutputStream {
        private byte[] buf;
        private int pos = -1;

        public void setBuf(byte[] buf, int minCapacity) {
            if (buf.length < minCapacity) {
                this.buf = new byte[minCapacity];
                this.pos = 0;
            } else {
                this.buf = buf;
                this.pos = 0;
            }
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public void close() throws IOException {
            super.close();
            this.buf = null;
        }

        public void flush() throws IOException {
            super.flush();
        }

        public void write(byte[] src, int start, int length) throws IOException {
            System.arraycopy(src, start, this.buf, this.pos, length);
            this.pos += length;
        }

        public void write(byte[] src) throws IOException {
            System.arraycopy(src, 0, this.buf, this.pos, src.length);
        }

        public void write(int num) throws IOException {
            SMPPIO.intToBytes(num, 4, this.buf, this.pos);
            this.pos += 4;
        }
    }
}

