/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.net;

import ie.omk.smpp.net.SmscLink;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TcpLink
extends SmscLink {
    private static final String STACK_TRACE_ERR = "Stack trace:";
    private static final String SOCKET_NOT_OPEN_ERR = "Socket connection is not open";
    private static final Log LOGGER = LogFactory.getLog((Class)TcpLink.class);
    public static final int DEFAULT_PORT = 5016;
    private InetAddress addr;
    private int port;
    private int sockTimeout;
    private Socket sock;
    private boolean connected;

    public TcpLink(String address) throws UnknownHostException {
        this(address, 5016);
    }

    public TcpLink(String address, int port) throws UnknownHostException {
        this.addr = InetAddress.getByName(address);
        this.port = port < 1 ? 5016 : port;
    }

    public TcpLink(InetAddress address) throws UnknownHostException {
        this(address, 5016);
    }

    public TcpLink(InetAddress address, int port) throws UnknownHostException {
        this.addr = address;
        this.port = port < 1 ? 5016 : port;
    }

    protected void implOpen() throws IOException {
        LOGGER.info((Object)("Opening TCP socket to " + this.addr + ":" + this.port));
        this.sock = new Socket();
        InetSocketAddress sockAddr = new InetSocketAddress(this.addr, this.port);
        this.sock.connect(sockAddr, this.sockTimeout);
        if (this.sockTimeout > 0) {
            this.sock.setSoTimeout(this.sockTimeout);
        }
        this.connected = true;
    }

    protected void implClose() throws IOException {
        if (this.connected && this.sock != null) {
            LOGGER.info((Object)"Shutting down socket connection");
            try {
                this.sock.close();
                this.sock = null;
                this.connected = false;
            }
            catch (IOException ix) {
                LOGGER.warn((Object)"I/O exception closing socket", (Throwable)ix);
                this.connected = false;
                ix.fillInStackTrace();
                throw ix;
            }
        }
    }

    protected OutputStream getOutputStream() throws IOException {
        if (this.sock == null) {
            throw new IOException(SOCKET_NOT_OPEN_ERR);
        }
        return this.sock.getOutputStream();
    }

    protected InputStream getInputStream() throws IOException {
        if (this.sock == null) {
            throw new IOException(SOCKET_NOT_OPEN_ERR);
        }
        return this.sock.getInputStream();
    }

    public InetAddress getAddress() {
        return this.addr;
    }

    public int getPort() {
        return this.port;
    }

    public int getConnectedPort() throws IOException {
        if (this.sock == null) {
            throw new IOException(SOCKET_NOT_OPEN_ERR);
        }
        return this.sock.getPort();
    }

    public int getLocalPort() throws IOException {
        if (this.sock == null) {
            throw new IOException(SOCKET_NOT_OPEN_ERR);
        }
        return this.sock.getLocalPort();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setTimeout(int timeout) {
        block3: {
            try {
                this.sockTimeout = timeout;
                if (this.sock != null) {
                    this.sock.setSoTimeout(this.sockTimeout);
                }
            }
            catch (SocketException x) {
                LOGGER.error((Object)("Failed to set timeout on socket: " + x.getMessage()));
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug((Object)STACK_TRACE_ERR, (Throwable)x);
            }
        }
    }

    public void setTimeout(long timeout) {
        block3: {
            try {
                this.sockTimeout = (int)timeout;
                if (this.sock != null) {
                    this.sock.setSoTimeout(this.sockTimeout);
                }
            }
            catch (SocketException x) {
                LOGGER.error((Object)("Failed to set timeout on socket: " + x.getMessage()));
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug((Object)STACK_TRACE_ERR, (Throwable)x);
            }
        }
    }

    public int getTimeout() {
        try {
            return this.sock.getSoTimeout();
        }
        catch (SocketException x) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)STACK_TRACE_ERR, (Throwable)x);
            }
            return -1;
        }
    }
}

