/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.util;

import ie.omk.smpp.util.ASCIIEncoding;
import ie.omk.smpp.util.AlphabetEncoding;
import ie.omk.smpp.util.BinaryEncoding;
import ie.omk.smpp.util.DefaultAlphabetEncoding;
import ie.omk.smpp.util.Latin1Encoding;
import ie.omk.smpp.util.MessageEncoding;
import ie.omk.smpp.util.UCS2Encoding;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EncodingFactory {
    private static final Log LOGGER = LogFactory.getLog((Class)EncodingFactory.class);
    private static final String DEFAULT_ALPHABET_PROPNAME = "smpp.default_alphabet";
    private static final EncodingFactory INSTANCE = new EncodingFactory();
    private final Map mappingTable = new HashMap();
    private final Map langToAlphabet = new HashMap();
    private AlphabetEncoding defaultAlphabet;

    public EncodingFactory() {
        DefaultAlphabetEncoding gsmDefault = new DefaultAlphabetEncoding();
        this.addEncoding(gsmDefault);
        this.addEncoding(new ASCIIEncoding());
        this.addEncoding(new BinaryEncoding());
        this.addEncoding(Latin1Encoding.class);
        this.addEncoding(UCS2Encoding.class);
        this.langToAlphabet.put("en", gsmDefault);
        this.langToAlphabet.put("de", gsmDefault);
        this.langToAlphabet.put("fr", gsmDefault);
        this.langToAlphabet.put("it", gsmDefault);
        this.langToAlphabet.put("nl", gsmDefault);
        this.langToAlphabet.put("es", gsmDefault);
        try {
            this.addEncoding(new UCS2Encoding());
            this.langToAlphabet.put(null, new UCS2Encoding());
        }
        catch (UnsupportedEncodingException x) {
            try {
                this.langToAlphabet.put(null, new Latin1Encoding());
            }
            catch (UnsupportedEncodingException xx) {
                LOGGER.debug((Object)"JVM does not support UCS2 - encoding will not be used.");
                this.langToAlphabet.put(null, new ASCIIEncoding());
            }
        }
        this.initDefaultAlphabet();
    }

    public static final EncodingFactory getInstance() {
        return INSTANCE;
    }

    public MessageEncoding getEncoding(int dataCoding) {
        return (MessageEncoding)this.mappingTable.get(new Integer(dataCoding));
    }

    public void addEncoding(MessageEncoding encoding) {
        this.mappingTable.put(new Integer(encoding.getDataCoding()), encoding);
    }

    public void addEncoding(Class encodingClass) {
        try {
            if (!MessageEncoding.class.isAssignableFrom(encodingClass)) {
                throw new IllegalArgumentException("Not an encoding class: " + encodingClass);
            }
            Constructor c = encodingClass.getConstructor(new Class[0]);
            this.addEncoding((MessageEncoding)c.newInstance(new Object[0]));
        }
        catch (NoSuchMethodException x) {
            LOGGER.error((Object)(encodingClass.getName() + " does not have a" + "no-argument constructor"), (Throwable)x);
        }
        catch (IllegalAccessException x) {
            LOGGER.error((Object)(encodingClass.getName() + " does not have a visible" + " no-argument constructor"), (Throwable)x);
        }
        catch (InstantiationException x) {
            LOGGER.error((Object)("Cannot instantiate an instance of " + encodingClass), (Throwable)x);
        }
        catch (InvocationTargetException x) {
            Throwable cause = x.getCause();
            if (cause instanceof UnsupportedEncodingException) {
                LOGGER.debug((Object)(encodingClass.getName() + " is not supported by the JVM"));
            } else {
                LOGGER.error((Object)(encodingClass.getName() + " constructor threw " + "an exception"), (Throwable)x);
            }
        }
        catch (IllegalArgumentException x) {
            LOGGER.error((Object)"This exception shouldn't happen", (Throwable)x);
        }
    }

    public Iterator getAllEncodings() {
        return this.mappingTable.values().iterator();
    }

    public AlphabetEncoding getDefaultAlphabet() {
        return this.defaultAlphabet;
    }

    public AlphabetEncoding getAlphabet(String lang) {
        AlphabetEncoding enc = (AlphabetEncoding)this.langToAlphabet.get(lang);
        if (enc != null) {
            return enc;
        }
        return (AlphabetEncoding)this.langToAlphabet.get(null);
    }

    private void initDefaultAlphabet() {
        String className = "";
        try {
            className = System.getProperty(DEFAULT_ALPHABET_PROPNAME);
            if (className != null) {
                Class<?> alphaClass = Class.forName(className);
                this.defaultAlphabet = (AlphabetEncoding)alphaClass.newInstance();
            }
        }
        catch (Exception x) {
            LOGGER.warn((Object)("Couldn't load default alphabet " + className), (Throwable)x);
        }
        if (this.defaultAlphabet == null) {
            this.defaultAlphabet = new DefaultAlphabetEncoding();
        }
    }
}

