/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api;

import com.droidkit.actors.ActorCreator;
import com.droidkit.actors.ActorRef;
import com.droidkit.actors.ActorSystem;
import com.droidkit.actors.Props;
import com.droidkit.actors.concurrency.Future;
import com.droidkit.actors.concurrency.FutureCallback;
import com.droidkit.actors.tasks.AskTimeoutException;
import com.droidkit.actors.typed.TypedCreator;
import im.actor.api.ActorApiConfig;
import im.actor.api.ApiRequestException;
import im.actor.api._internal.ApiBrokerActor;
import im.actor.api._internal.TypedRequestActor;
import im.actor.api._internal.TypedRequestInt;
import im.actor.api.parser.Request;
import im.actor.api.parser.Response;
import im.actor.api.scheme.ApiRequests;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class ActorApi {
    private static AtomicInteger NEXT_ID = new AtomicInteger(0);
    private ActorRef broker;
    private TypedRequestInt requestInt;
    private int id = NEXT_ID.getAndIncrement();
    private ApiRequests requests;

    public ActorApi(ActorApiConfig reactiveConfig) {
        this.broker = ActorSystem.system().actorOf(ApiBrokerActor.broker("" + this.id, reactiveConfig));
        this.requestInt = (TypedRequestInt)TypedCreator.typed((ActorRef)ActorSystem.system().actorOf(Props.create(TypedRequestActor.class, (ActorCreator)new ActorCreator<TypedRequestActor>(){

            public TypedRequestActor create() {
                return new TypedRequestActor(ActorApi.this.broker);
            }
        }), "/actor-api/" + this.id + "/rpc"), TypedRequestInt.class);
        this.requests = new ApiRequests(this);
    }

    public ApiRequests getRequests() {
        return this.requests;
    }

    public <T extends Response> Future<T> rpc(Request<T> message, FutureCallback<T> callback) {
        Future<Response> res = this.requestInt.request(message);
        if (callback != null) {
            res.addListener(callback);
        }
        return res;
    }

    public <T extends Response> Future<T> rpc(Request<T> message, long timeout, FutureCallback<T> callback) {
        Future<Response> res = this.requestInt.request(message, timeout);
        if (callback != null) {
            res.addListener(callback);
        }
        return res;
    }

    public <T extends Response> Future<T> rpc(Request<T> message) {
        return this.rpc(message, null);
    }

    public <T extends Response> Future<T> rpc(Request<T> message, long timeout) {
        return this.rpc(message, timeout, null);
    }

    public <T extends Response> T rpcSync(Request<T> message) throws TimeoutException, ApiRequestException {
        return this.rpcSync(message, 5000L);
    }

    public <T extends Response> T rpcSync(Request<T> message, long timeout) throws TimeoutException, ApiRequestException {
        Object[] res;
        Object[] objectArray = res = new Object[2];
        synchronized (res) {
            this.rpc(message, timeout, new FutureCallback<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onResult(T result) {
                    Object[] objectArray = res;
                    synchronized (res) {
                        res[0] = true;
                        res[1] = result;
                        res.notifyAll();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onError(Throwable throwable) {
                    Object[] objectArray = res;
                    synchronized (res) {
                        res[0] = false;
                        res[1] = throwable;
                        res.notifyAll();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
            try {
                res.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new TimeoutException();
            }
            if (Boolean.TRUE.equals(res[0])) {
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return (T)((Object)((Response)((Object)res[1])));
            }
            if (res[1] instanceof ApiRequestException) {
                throw (ApiRequestException)res[1];
            }
            if (res[1] instanceof AskTimeoutException) {
                throw new TimeoutException();
            }
            throw new RuntimeException((Throwable)res[1]);
        }
    }

    public void notifyNetworkChanged() {
        this.broker.send((Object)new ApiBrokerActor.NetworkChanged());
    }

    public void dispose() {
        this.broker.send((Object)new ApiBrokerActor.Destroy());
    }
}

