/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;

public class Crypto {
    protected static final char[] hexArray = "0123456789abcdef".toCharArray();

    public static SecureRandom getSecureRandom() {
        try {
            return SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Cipher createAESCipher() {
        try {
            return Cipher.getInstance("AES/CBC/PKCS5Padding");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Cipher createRSACipher() {
        try {
            return Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Mac createHmacSHA256() {
        try {
            return Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static byte[] generateSeed(int size) {
        byte[] key = new byte[size];
        Crypto.getSecureRandom().nextBytes(key);
        return key;
    }

    public static long generateSessionId() {
        return Crypto.getSecureRandom().nextLong();
    }

    public static byte[] SHA256(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return digest.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("No SHA-256 available");
        }
    }

    public static byte[] SHA1(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            return digest.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("No SHA-1 available");
        }
    }

    public static String hex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

