/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.crypto;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class KeyTools {
    public static byte[] encodeRsaPublicKey(PublicKey publicKey) {
        return publicKey.getEncoded();
    }

    public static PublicKey decodeRsaPublicKey(byte[] encoded) {
        KeyFactory keyFactory;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        try {
            return keyFactory.generatePublic(new X509EncodedKeySpec(encoded));
        }
        catch (InvalidKeySpecException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static byte[] encodeRsaPrivateKey(PrivateKey privateKey) {
        return privateKey.getEncoded();
    }

    public static PrivateKey decodeRsaPrivateKey(byte[] encoded) {
        KeyFactory keyFactory;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        try {
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encoded));
        }
        catch (InvalidKeySpecException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static KeyPair generateNewRsaKey() {
        KeyPairGenerator g = null;
        try {
            g = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        g.initialize(1024);
        return g.generateKeyPair();
    }
}

