/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.mtp;

import com.droidkit.actors.ActorRef;
import com.droidkit.actors.ActorSystem;
import com.droidkit.actors.messages.PoisonPill;
import im.actor.api.mtp.MTProtoParams;
import im.actor.api.mtp._internal.EndpointProvider;
import im.actor.api.mtp._internal.MTUids;
import im.actor.api.mtp._internal.actors.ManagerActor;
import im.actor.api.mtp._internal.actors.ReceiverActor;
import im.actor.api.mtp._internal.actors.SenderActor;
import im.actor.api.mtp._internal.entity.message.RpcRequestBox;
import im.actor.api.mtp._internal.entity.message.rpc.RpcRequest;

public class MTProto {
    private MTProtoParams params;
    private EndpointProvider endpointProvider;
    private MTUids uids;
    private String path;
    private int connectionCount;
    private ActorRef manager;
    private ActorRef sender;
    private ActorRef receiver;
    private ActorRef stateBroker;

    public MTProto(MTProtoParams params, String path, int desiredConnectionCount, ActorRef stateBroker) {
        if (params.getSessionId() == 0L) {
            throw new RuntimeException("Session can't be zero");
        }
        if (params.getAuthId() == 0L) {
            throw new RuntimeException("AuthId can't be zero");
        }
        this.path = path;
        this.params = params;
        this.endpointProvider = new EndpointProvider(params.getConfig().getEndpoints());
        this.stateBroker = stateBroker;
        this.uids = new MTUids();
        this.connectionCount = desiredConnectionCount;
        this.manager = ActorSystem.system().actorOf(ManagerActor.manager(this));
        this.sender = ActorSystem.system().actorOf(SenderActor.senderActor(this));
        this.receiver = ActorSystem.system().actorOf(ReceiverActor.receiver(this));
    }

    public String getPath() {
        return this.path;
    }

    public int getConnectionCount() {
        return this.connectionCount;
    }

    public MTProtoParams getParams() {
        return this.params;
    }

    public ActorRef getStateBroker() {
        return this.stateBroker;
    }

    public MTUids getUids() {
        return this.uids;
    }

    public EndpointProvider getEndpointProvider() {
        return this.endpointProvider;
    }

    public long sendRpcRequest(RpcRequest request) {
        long rid = this.uids.nextId();
        RpcRequestBox rpcRequestBox = new RpcRequestBox(request.toByteArray());
        this.sender.send((Object)new SenderActor.SendMessage(rid, rpcRequestBox, true));
        return rid;
    }

    public void cancelRequest(long rid) {
        this.sender.send((Object)new SenderActor.CancelMessage(rid));
    }

    public void notifyNetworkStateChanged() {
        this.manager.send((Object)new ManagerActor.NetworkChanged());
    }

    public void close() {
        this.manager.send((Object)PoisonPill.INSTANCE);
        this.sender.send((Object)PoisonPill.INSTANCE);
        this.receiver.send((Object)PoisonPill.INSTANCE);
    }
}

