/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.mtp._internal.actors;

import com.droidkit.actors.Actor;
import com.droidkit.actors.ActorCreator;
import com.droidkit.actors.ActorRef;
import com.droidkit.actors.ActorSelection;
import com.droidkit.actors.Props;
import im.actor.api.LogInterface;
import im.actor.api.mtp.MTProto;
import im.actor.api.mtp.MTProtoParams;
import im.actor.api.mtp._internal.MTUids;
import im.actor.api.mtp._internal.actors.ManagerActor;
import im.actor.api.mtp._internal.entity.ProtoMessage;
import im.actor.api.mtp._internal.entity.ProtoPackage;
import im.actor.api.mtp._internal.entity.ProtoStruct;
import im.actor.api.mtp._internal.entity.message.Container;
import im.actor.api.mtp._internal.entity.message.MessageAck;
import im.actor.api.mtp._internal.entity.message.Ping;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class SenderActor
extends Actor {
    private static final String TAG = "ProtoSender";
    private static final int ACK_THRESHOLD = 10;
    private static final int ACK_DELAY = 10000;
    private static final int MAX_WORKLOAD_SIZE = 1024;
    private final LogInterface LOG;
    private final boolean DEBUG;
    private ActorRef manager;
    private MTProtoParams params;
    private MTUids uids;
    private HashMap<Long, UnsentPackageHolder> unsentPackages;
    private HashSet<Long> confirm;
    private MTProto proto;

    public static ActorSelection senderActor(final MTProto proto) {
        return new ActorSelection(Props.create(SenderActor.class, (ActorCreator)new ActorCreator<SenderActor>(){

            public SenderActor create() {
                return new SenderActor(proto);
            }
        }), proto.getPath() + "/sender");
    }

    public SenderActor(MTProto proto) {
        this.proto = proto;
        this.uids = proto.getUids();
        this.params = proto.getParams();
        this.unsentPackages = new HashMap();
        this.confirm = new HashSet();
        this.LOG = proto.getParams().getConfig().getLogInterface();
        this.DEBUG = proto.getParams().getConfig().isDebugProto();
    }

    public void preStart() {
        this.manager = this.system().actorOf(ManagerActor.manager(this.proto));
    }

    public void onReceive(Object message) {
        if (message instanceof SendMessage) {
            if (this.LOG != null && this.DEBUG) {
                this.LOG.d(TAG, "Received SendMessage #" + ((SendMessage)message).rid);
            }
            SendMessage sendMessage = (SendMessage)message;
            this.doSend(new ProtoMessage(sendMessage.rid, sendMessage.struct.toByteArray()));
            this.unsentPackages.put(sendMessage.rid, new UnsentPackageHolder(sendMessage.struct, sendMessage.rid, sendMessage.isRpc));
        } else if (message instanceof ConnectionCreated) {
            if (this.LOG != null && this.DEBUG) {
                this.LOG.d(TAG, "Received ConnectionCreated #" + ((ConnectionCreated)message).connectionId);
            }
            ArrayList<ProtoMessage> toSend = new ArrayList<ProtoMessage>();
            for (UnsentPackageHolder unsentPackage : this.unsentPackages.values()) {
                if (!unsentPackage.needResend) continue;
                if (this.LOG != null && this.DEBUG) {
                    this.LOG.d(TAG, "ReSending #" + unsentPackage.rid);
                }
                toSend.add(new ProtoMessage(unsentPackage.rid, unsentPackage.message.toByteArray()));
            }
            if (toSend.size() == 0) {
                toSend.add(new ProtoMessage(this.uids.nextId(), new Ping(this.uids.nextId()).toByteArray()));
            }
            this.doSend(toSend);
        } else if (message instanceof ConnectionDies) {
            if (this.LOG != null && this.DEBUG) {
                this.LOG.d(TAG, "Received ConnectionDies #" + ((ConnectionDies)message).connectionId);
            }
            ArrayList<ProtoMessage> toSend = new ArrayList<ProtoMessage>();
            for (UnsentPackageHolder unsentPackage : this.unsentPackages.values()) {
                if (unsentPackage.sentToConnection != ((ConnectionDies)message).connectionId) continue;
                unsentPackage.needResend = true;
                unsentPackage.sentToConnection = 0;
                toSend.add(new ProtoMessage(unsentPackage.rid, unsentPackage.message.toByteArray()));
            }
            this.doSend(toSend);
        } else if (message instanceof ForgetMessage) {
            UnsentPackageHolder packageHolder;
            if (this.LOG != null && this.DEBUG) {
                this.LOG.d(TAG, "Received ForgetMessage #" + ((ForgetMessage)message).rid);
            }
            if ((packageHolder = this.unsentPackages.get(((ForgetMessage)message).rid)) != null && !packageHolder.isRpc) {
                this.unsentPackages.remove(((ForgetMessage)message).rid);
            }
        } else if (message instanceof RpcResponseReceived) {
            if (this.LOG != null && this.DEBUG) {
                this.LOG.d(TAG, "Received RpcResponseReceived #" + ((RpcResponseReceived)message).rid);
            }
            this.unsentPackages.remove(((RpcResponseReceived)message).rid);
        } else if (message instanceof CancelMessage) {
            if (this.LOG != null && this.DEBUG) {
                this.LOG.d(TAG, "Received CancelMessage #" + ((CancelMessage)message).rid);
            }
            this.unsentPackages.remove(((CancelMessage)message).rid);
        } else if (message instanceof ManagerActor.MessageSent) {
            ManagerActor.MessageSent sent = (ManagerActor.MessageSent)message;
            if (this.LOG != null && this.DEBUG) {
                this.LOG.d(TAG, "Received MessageSent #" + sent.getRid() + " to #" + sent.getConnectionId());
            }
            if (this.unsentPackages.containsKey(sent.getRid())) {
                UnsentPackageHolder unsentPackage = this.unsentPackages.get(sent.getRid());
                unsentPackage.sentToConnection = sent.getConnectionId();
                unsentPackage.needResend = false;
                if (this.LOG != null && this.DEBUG) {
                    this.LOG.d(TAG, "Message #" + sent.getRid() + " marked");
                }
            }
        } else if (message instanceof ConfirmMessage) {
            if (this.LOG != null && this.DEBUG) {
                this.LOG.d(TAG, "Confirming message #" + ((ConfirmMessage)message).rid);
            }
            this.confirm.add(((ConfirmMessage)message).rid);
            if (this.confirm.size() >= 10) {
                this.self().sendOnce((Object)new ForceAck());
            } else if (this.confirm.size() == 1) {
                this.self().sendOnce((Object)new ForceAck(), 10000L);
            }
        } else if (message instanceof ForceAck) {
            if (this.confirm.size() == 0) {
                return;
            }
            if (this.LOG != null && this.DEBUG) {
                String acks = "";
                for (Long l : this.confirm) {
                    if (acks.length() != 0) {
                        acks = acks + ",";
                    }
                    acks = acks + "#" + l;
                }
                this.LOG.d(TAG, "Sending acks " + acks);
            }
            MessageAck messageAck = this.buildAck();
            this.confirm.clear();
            this.doSend(new ProtoMessage(this.uids.nextId(), messageAck.toByteArray()));
        } else if (message instanceof NewSession) {
            ArrayList<ProtoMessage> toSend = new ArrayList<ProtoMessage>();
            for (UnsentPackageHolder unsentPackage : this.unsentPackages.values()) {
                unsentPackage.needResend = true;
                if (this.LOG != null && this.DEBUG) {
                    this.LOG.d(TAG, "ReSending #" + unsentPackage.rid);
                }
                toSend.add(new ProtoMessage(unsentPackage.rid, unsentPackage.message.toByteArray()));
            }
            this.doSend(toSend);
        }
    }

    private MessageAck buildAck() {
        long[] ids = new long[this.confirm.size()];
        Long[] ids2 = this.confirm.toArray(new Long[this.confirm.size()]);
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = ids2[i];
        }
        return new MessageAck(ids);
    }

    private void doSend(List<ProtoMessage> items) {
        if (items.size() > 0 && this.confirm.size() > 0) {
            items.add(0, new ProtoMessage(this.uids.nextId(), this.buildAck().toByteArray()));
            this.confirm.clear();
        }
        if (items.size() == 1) {
            this.doSend(items.get(0));
        } else if (items.size() > 1) {
            ArrayList<ProtoMessage> messages = new ArrayList<ProtoMessage>();
            int currentPayload = 0;
            for (int i = 0; i < items.size(); ++i) {
                ProtoMessage message = items.get(i);
                messages.add(message);
                if ((currentPayload += message.getLength()) <= 1024) continue;
                Container container = new Container(messages.toArray(new ProtoMessage[messages.size()]));
                this.performSend(new ProtoMessage(this.uids.nextId(), container.toByteArray()));
                messages.clear();
                currentPayload = 0;
            }
            if (messages.size() > 0) {
                Container container = new Container(messages.toArray(new ProtoMessage[messages.size()]));
                this.performSend(new ProtoMessage(this.uids.nextId(), container.toByteArray()));
            }
        }
    }

    private void doSend(ProtoMessage message) {
        if (this.confirm.size() > 0) {
            ArrayList<ProtoMessage> mtpMessages = new ArrayList<ProtoMessage>();
            mtpMessages.add(message);
            this.doSend(mtpMessages);
        } else {
            this.performSend(message);
        }
    }

    private void performSend(ProtoMessage message) {
        try {
            ProtoPackage protoPackage = new ProtoPackage(this.params.getAuthId(), this.params.getSessionId(), message);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(protoPackage.getLength());
            protoPackage.writeObject(outputStream);
            byte[] data = outputStream.toByteArray();
            this.manager.send((Object)new ManagerActor.SendMessage(message.messageId, data));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class UnsentPackageHolder {
        private final long rid;
        private final ProtoStruct message;
        private int sentToConnection;
        private boolean needResend;
        private boolean isRpc;

        private UnsentPackageHolder(ProtoStruct message, long rid, boolean isRpc) {
            this.message = message;
            this.rid = rid;
            this.needResend = true;
            this.isRpc = isRpc;
        }
    }

    public static class ForceAck {
    }

    public static class NewSession {
    }

    public static class ConnectionDies {
        private int connectionId;

        public ConnectionDies(int connectionId) {
            this.connectionId = connectionId;
        }
    }

    public static class ConnectionCreated {
        private int connectionId;

        public ConnectionCreated(int connectionId) {
            this.connectionId = connectionId;
        }
    }

    public static class ConfirmMessage {
        private long rid;

        public ConfirmMessage(long rid) {
            this.rid = rid;
        }
    }

    public static class RpcResponseReceived {
        private long rid;

        public RpcResponseReceived(long rid) {
            this.rid = rid;
        }
    }

    public static class CancelMessage {
        private long rid;

        public CancelMessage(long rid) {
            this.rid = rid;
        }
    }

    public static class ForgetMessage {
        private long rid;

        public ForgetMessage(long rid) {
            this.rid = rid;
        }
    }

    public static class SendMessage {
        private long rid;
        private ProtoStruct struct;
        private boolean isRpc;

        public SendMessage(long rid, ProtoStruct struct, boolean isRpc) {
            this.isRpc = isRpc;
            this.rid = rid;
            this.struct = struct;
        }
    }
}

