/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.mtp._internal.entity;

import im.actor.api.mtp._internal.entity.ProtoStruct;
import im.actor.api.mtp._internal.entity.message.Container;
import im.actor.api.mtp._internal.entity.message.Drop;
import im.actor.api.mtp._internal.entity.message.MessageAck;
import im.actor.api.mtp._internal.entity.message.NewSession;
import im.actor.api.mtp._internal.entity.message.Ping;
import im.actor.api.mtp._internal.entity.message.Pong;
import im.actor.api.mtp._internal.entity.message.RequestAuthId;
import im.actor.api.mtp._internal.entity.message.ResponseAuthId;
import im.actor.api.mtp._internal.entity.message.RpcRequestBox;
import im.actor.api.mtp._internal.entity.message.RpcResponseBox;
import im.actor.api.mtp._internal.entity.message.UnsentMessage;
import im.actor.api.mtp._internal.entity.message.UnsentResponse;
import im.actor.api.mtp._internal.entity.message.UpdateBox;
import im.actor.api.mtp._internal.entity.message.rpc.RpcError;
import im.actor.api.mtp._internal.entity.message.rpc.RpcFloodWait;
import im.actor.api.mtp._internal.entity.message.rpc.RpcInternalError;
import im.actor.api.mtp._internal.entity.message.rpc.RpcOk;
import im.actor.api.mtp._internal.entity.message.rpc.RpcRequest;
import im.actor.api.mtp._internal.entity.message.rpc.Update;
import im.actor.api.util.StreamingUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProtoSerializer {
    public static ProtoStruct readMessagePayload(byte[] bs) throws IOException {
        return ProtoSerializer.readMessagePayload(new ByteArrayInputStream(bs));
    }

    public static ProtoStruct readMessagePayload(InputStream bs) throws IOException {
        byte header = StreamingUtils.readByte(bs);
        switch (header) {
            case -16: {
                return new RequestAuthId(bs);
            }
            case -15: {
                return new ResponseAuthId(bs);
            }
            case 1: {
                return new Ping(bs);
            }
            case 2: {
                return new Pong(bs);
            }
            case 13: {
                return new Drop(bs);
            }
            case 10: {
                return new Container(bs);
            }
            case 3: {
                return new RpcRequestBox(bs);
            }
            case 4: {
                return new RpcResponseBox(bs);
            }
            case 6: {
                return new MessageAck(bs);
            }
            case 12: {
                return new NewSession(bs);
            }
            case 5: {
                return new UpdateBox(bs);
            }
            case 7: {
                return new UnsentMessage(bs);
            }
            case 8: {
                return new UnsentResponse(bs);
            }
            case 9: {
                return new UnsentResponse(bs);
            }
        }
        throw new IOException("Unable to read proto object with header #" + header);
    }

    public static ProtoStruct readRpcResponsePayload(byte[] bs) throws IOException {
        return ProtoSerializer.readRpcResponsePayload(new ByteArrayInputStream(bs));
    }

    public static ProtoStruct readRpcResponsePayload(InputStream bs) throws IOException {
        byte header = StreamingUtils.readByte(bs);
        switch (header) {
            case 1: {
                return new RpcOk(bs);
            }
            case 2: {
                return new RpcError(bs);
            }
            case 3: {
                return new RpcFloodWait(bs);
            }
            case 4: {
                return new RpcInternalError(bs);
            }
        }
        throw new IOException("Unable to read proto object");
    }

    public static ProtoStruct readRpcRequestPayload(InputStream bs) throws IOException {
        byte header = StreamingUtils.readByte(bs);
        switch (header) {
            case 1: {
                return new RpcRequest(bs);
            }
        }
        throw new IOException("Unable to read proto object with header #" + header);
    }

    public static Update readUpdate(byte[] bs) throws IOException {
        return ProtoSerializer.readUpdate(new ByteArrayInputStream(bs));
    }

    public static Update readUpdate(InputStream bs) throws IOException {
        return new Update(bs);
    }
}

